/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import butterfly.actions.interfaces.ICreateDocumentStubAction;
import butterfly.xmlview.model.validation.XmlStructureBuilder;
/**
 * Insert the type's description here.
 * Creation date: (12/7/2002 4:41:01 PM)
 * @author: 
 */
public class CreateDocumentStubAction extends DocumentAction implements ICreateDocumentStubAction{
	private String rootElement_;
	private String stub_;
/**
 * CreateDocumentStubAction constructor comment.
 */
public CreateDocumentStubAction() {
	super();
}
/**
 * CreateDocumentStubAction constructor comment.
 * @param name java.lang.String
 */
public CreateDocumentStubAction(String name) {
	super(name);
}
/**
 * CreateDocumentStubAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public CreateDocumentStubAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent e1) {
	stub_ = "<?xml version=\"1.0\"?>\n";
	XmlStructureBuilder builder = new XmlStructureBuilder();
	try{
		//stub_ +=  builder.buildDocumentStub(getRootElement(),getDocument().toString(),getDocument().getContentType().equals(IValidationDocument.TEXT_DTD_TYPE));
		
	}catch(Exception e){
		e.printStackTrace();	
	}

	//return stub;
}
/**
 * Insert the method's description here.
 * Creation date: (12/7/2002 4:42:39 PM)
 * @return java.lang.String
 */
public java.lang.String getRootElement() {
	return rootElement_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/7/2002 4:49:57 PM)
 * @return java.lang.String
 */
public java.lang.String getStub() {
	return stub_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/7/2002 4:42:39 PM)
 * @param newRootElement java.lang.String
 */
public void setRootElement(java.lang.String newRootElement) {
	rootElement_ = newRootElement;
}
/**
 * Insert the method's description here.
 * Creation date: (12/7/2002 4:49:57 PM)
 * @param newStub java.lang.String
 */
public void setStub(java.lang.String newStub) {
	stub_ = newStub;
}
}
