package butterfly.actions;

import java.awt.event.ActionEvent;
import java.util.Hashtable;

import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.interfaces.IElement;

/**
 * @author Jules White
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DeclarePrefixAction extends ButterflyAction {
	private IElement element_;
	private String prefix_;
	private String uri_;
	
	public DeclarePrefixAction(){}
	public DeclarePrefixAction(String pre, String uri){
		prefix_=pre;
		uri_=uri;	
	}
	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try{
			if(prefix_==null){
				IXmlViewInformer informer = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
				Hashtable result = informer.displayQuery("Declare namespace prefix mapping:",new String[]{"Prefix","URI"});
				String prefix = (String)result.get("Prefix");
				String uri = (String)result.get("URI");
				uri_=uri;
				prefix_=prefix;
			}
			Attribute attr = new Attribute("xmlns:"+prefix_);
			attr.setData(uri_);
			element_.addAttribute(attr);
			element_.getDocument().updateNode(element_,true);
			
		}catch(Exception ex){
			
		}
		prefix_=null;
		uri_=null;
	}

	/**
	 * Returns the element_.
	 * @return IElement
	 */
	public IElement getElement() {
		return element_;
	}

	/**
	 * Returns the prefix_.
	 * @return String
	 */
	public String getPrefix() {
		return prefix_;
	}

	/**
	 * Returns the uri_.
	 * @return String
	 */
	public String getUri() {
		return uri_;
	}

	/**
	 * Sets the element_.
	 * @param element_ The element_ to set
	 */
	public void setElement(IElement element) {
		this.element_ = element;
	}

	/**
	 * Sets the prefix_.
	 * @param prefix_ The prefix_ to set
	 */
	public void setPrefix(String prefix) {
		this.prefix_ = prefix;
	}

	/**
	 * Sets the uri_.
	 * @param uri_ The uri_ to set
	 */
	public void setUri(String uri) {
		this.uri_ = uri;
	}

}
