/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import org.apache.log4j.Logger;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 6:31:40 PM)
 * @author: 
 */
public class DocumentSaveAction extends ButterflyAction implements butterfly.actions.interfaces.IFileSaveAction {
	private static Logger logger_ = Logger.getLogger(FileSaveAction.class);
	private IDocument document_;
/**
 * FileSaveAction constructor comment.
 */
public DocumentSaveAction() {
	super();
}
/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 */
public DocumentSaveAction(String name) {
	super(name);
}
/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public DocumentSaveAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
    IXmlViewInformer informer =
        (IXmlViewInformer) getLookup().getComponent(IXmlViewInformer.ROLE);
    File file = null;
    try {

      
        IDocument doc = document_;


        
        if (doc.getSourceFileName() != null) {
            file = new File(doc.getSourceFileName());

        } else {

            IFileChooseAction choosefile =
                (IFileChooseAction) getActionLookup().getAction(IFileChooseAction.ROLE);
            choosefile.setMode(IFileChooseAction.OPEN_MODE);
            choosefile.actionPerformed(null);

            file = choosefile.getSelectedFile();

        }

        if (file != null) {
            IContentHandlerLookup handlerlookup =
                (IContentHandlerLookup) getLookup().getComponent(IContentHandlerLookup.ROLE);

            IContentHandler handler =
                handlerlookup.getContentHandlerForFiletype(doc.getContentType());
            handler.saveDocument(file.getCanonicalPath(), doc);
            doc.setDirty(false);
        }
        /*
        javax.swing.JFileChooser chooser =
            (JFileChooser) getLookup().getComponent(IFileDialog.ROLE);
        javax.swing.JDesktopPane pane =
            (JDesktopPane) getLookup().getComponent(IButterflyDesktop.ROLE);
        
        
        IDocumentFrame docframe = (IDocumentFrame)getLookup().getComponent(IDocumentFrame.ROLE);
        IDocumentView editor = (IDocumentView)docframe.getActiveDocumentView();
        IDocument doc = editor.getIDocument();
        String savename = null;
        if (doc.getSourceFileName() != null) {
            savename = doc.getSourceFileName();
        } else {
        /*
            int returnVal = chooser.showSaveDialog(pane);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                
                
                boolean acceptover = true;
                if (chooser.getSelectedFile().exists()) {
                    acceptover =
                        informer.displayConfirmation(
                            "The file already exists. Are you sure you want to overwrite it?");
        
                }
                if (!acceptover) {
                   return;
        
                }
                try{
               	 savename = chooser.getSelectedFile().getCanonicalPath();
                }catch(Exception e){
                     informer.displayError("Unable to save file\n" + e);
                     return;
                }
            } else {
                return;
            }
            
            getActionLookup().getAction(IFileSaveAsAction.ROLE).actionPerformed(null);
            return;
        }
        try {
            IFileSystem loader = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
            logger_.debug("file system retrieved = "+(loader != null));
            logger_.debug("Saving file to:" + savename);
            loader.saveFile(savename, doc.toString());
            logger_.debug("File Saved.");
        	if(!savename.equals(doc.getSourceFileName())){
        		docframe.changeDocumentViewName(doc.getSourceFileName(),savename);
        		doc.setSourceFileName(savename);
        	}
        	*/

    } catch (Exception e) {

        informer.displayError("Unable to save file\n" + e);

    }
    // }
}
/**
 * Insert the method's description here.
 * Creation date: (11/14/2002 5:46:00 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/14/2002 5:46:00 PM)
 * @param newDocument butterfly.xmlview.model.interfaces.IDocument
 */
public void setDocument(butterfly.xmlview.model.interfaces.IDocument newDocument) {
	document_ = newDocument;
}
}
