/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.util.Hashtable;

import org.apache.log4j.Logger;

import butterfly.statemachine.DocumentEditorStateEvent;
import butterfly.statemachine.StateEvent;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IEditPane;
import butterfly.xmlview.gui.interfaces.IXmlStructurePane;
import butterfly.xmlview.model.interfaces.IEditable;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (12/4/2002 1:18:36 PM)
 * @author: 
 */
public class ElementSelectionAction extends ButterflyAction {
	private static Logger logger_ =
		Logger.getLogger(ElementSelectionAction.class);
	/**
	 * ElementSelectionAction constructor comment.
	 */
	public ElementSelectionAction() {
		super();
	}
	/**
	 * Invoked when an action occurs.
	 */
	public void actionPerformed(java.awt.event.ActionEvent e) {
		logger_.debug("SourceElementSelectionAction>>actionPerformed()");
		//String key = Profiler.startw("ElementSelectionAction.actionPerformed()");
		Hashtable data = getStateEventData();
		if (data != null) {
			Object src = data.get(StateEvent.SOURCE_KEY);
			//logger_.debug("getting data....");
			INode[] nodes =
				(INode[]) data.get(DocumentEditorStateEvent.CHANGED_NODES_KEY);
			if (nodes == null) {
				INode node =
					(INode) data.get(IDocumentEditor.SELECTED_NODE_KEY);
				if (node != null) {
					nodes = new INode[] { node };

				}

			}

			if (nodes != null) {
				INode node = nodes[0];
				logger_.debug("Show structure for : "+node);
				if (node == null || node.getDocument() == null) {
					//Profiler.endw(key);
					return;
				}
				if(node.getDocument() == null){return;}
				if (node.getDocument() instanceof IXmlDocument
					&& node instanceof IElement) {
					//Profiler.start("ElementSelectionAction.actionPerformed() - Show Element Structure");
					IXmlDocument doc = (IXmlDocument) node.getDocument();
					IElementStructure[] structure = doc.getElementStructures();
					logger_.debug("loading element structure : "+structure);
					if (structure != null) {
						IXmlStructurePane pane =
							(IXmlStructurePane) getLookup().getComponent(
								IXmlStructurePane.ROLE);
						if (!pane.equals(src)) {
							pane.setDocument(doc);
							pane.displayStructureFor(
								((IElement) node).getLocalName(),
								((IElement) node).getNameSpace());
						}
					}
					//Profiler.end("ElementSelectionAction.actionPerformed() - Show Element Structure");
				}
				if (node instanceof IEditable) {
					//Profiler.start("ElementSelectionAction.actionPerformed() - Update Edit Pane");
					IEditPane epane =
						(IEditPane) getLookup().getComponent(IEditPane.ROLE);
					if (!epane.equals(src)) {
						epane.edit((IEditable) node);
					}
					//Profiler.end("ElementSelectionAction.actionPerformed() - Update Edit Pane");
				}
				IDocumentEditorOrganizer frame =
					(IDocumentEditorOrganizer) getLookup().getComponent(
						IDocumentEditorOrganizer.ROLE);

			
				
				if(frame.containsDocumentEditor(node.getDocument())){
					//Profiler.start("ElementSelectionAction.actionPerformed() - FocusOnNode Active DocumentEditor");
					//logger_.debug("src:"+src);
					//logger_.debug("active editor:"+frame.getActiveDocumentEditor());
					if(!src.equals(frame.getActiveDocumentEditor())){
					frame.showDocumentEditor(node.getDocument());
					IDocumentEditor view = frame.getActiveDocumentEditor();
					
					view.focusOnNode(node);
					//Profiler.end("ElementSelectionAction.actionPerformed() - FocusOnNode Active DocumentEditor");
					}
					
				}

			}

		}
		//Profiler.endw(key);
	}
}
