/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.xmlview.gui.interfaces.IButterflyDesktop;
import butterfly.xmlview.gui.interfaces.IFileDialog;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
/**
 * Insert the type's description here.
 * Creation date: (9/2/2002 1:23:59 PM)
 * @author: 
 */
public class FileChooseAction extends ButterflyAction implements IFileChooseAction {
	private String approveText_ = null;
	private File selectedFile_ = null;
	private String message_ = null;
	private int mode = OPEN_MODE;
	
	private String[] filters_={"xml","dtd","xsd","xsl"};
	private String[] descs_={"XML","Document Type Definition","XML Schema","XML Stylesheet"};
/**
 * FileChooseAction constructor comment.
 */
public FileChooseAction() {
	super();
}
/**
 * FileChooseAction constructor comment.
 * @param name java.lang.String
 */
public FileChooseAction(String name) {
	super(name);
}
/**
 * FileChooseAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public FileChooseAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent e) {
    selectedFile_ = null;
	
    IFileDialog chooser = (IFileDialog) getLookup().getComponent(IFileDialog.ROLE);
    if(filters_!=null){
    	chooser.setFileFilters(filters_,descs_);	
    }
    if(approveText_ != null){
		chooser.setApproveText(approveText_);
		approveText_ = null;
    }
    java.awt.Component pane =
        (java.awt.Component) getLookup().getComponent(IButterflyDesktop.ROLE);
    IXmlViewInformer informer =
        (IXmlViewInformer) getLookup().getComponent(IXmlViewInformer.ROLE);
    int accept = -1;
    if (mode == OPEN_MODE) {
        accept = chooser.showOpenDialog(pane);
    } else {
        accept = chooser.showSaveDialog(pane);
    }
    if (accept == IFileDialog.APPROVE_OPTION) {
        selectedFile_ = chooser.getSelectedFile();
    }
   // descs_=null;
   // filters_= null;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:58:34 PM)
 * @return java.lang.String
 */
public java.lang.String getApproveText() {
	return approveText_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:58:24 AM)
 * @return java.awt.Component
 * @param name java.lang.String
 */
public butterfly.components.interfaces.IComponent getComponent(java.lang.String name) {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 1:30:09 PM)
 * @return int
 */
public int getMode() {
	return mode;
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 1:30:20 PM)
 * @return java.io.File
 */
public java.io.File getSelectedFile() {
	return selectedFile_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:58:34 PM)
 * @param newApproveText java.lang.String
 */
public void setApproveText(java.lang.String newApproveText) {
	approveText_ = newApproveText;
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 1:30:09 PM)
 * @param newMode int
 */
public void setMode(int newMode) {
	mode = newMode;
}
	/**
	 * @see butterfly.actions.interfaces.IFileChooseAction#setFileFilters(String[], String[])
	 */
public void setFileFilters(String[] exts, String[] desc) {
	filters_ = exts;
	descs_=desc;
}

}
