/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IFileSaveAction;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlOutline;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/31/2002 2:03:54 AM)
 * @author: 
 */
public class FileCloseAction extends ButterflyAction implements butterfly.actions.interfaces.IFileCloseAction {
	private static Logger logger_ = Logger.getLogger(FileCloseAction.class);
	private boolean closeAll_ = false;
	private boolean exit_ = false;
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_close-16.png");
/**
 * FileCloseAction constructor comment.
 */
public FileCloseAction() {
	super(null,icon_);
}
/**
 * FileCloseAction constructor comment.
 * @param name java.lang.String
 */
public FileCloseAction(String name) {
	super(name);
}
/**
 * FileCloseAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public FileCloseAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent e) {
	if(closeAll_){
		closeAll();		
		return;
	}
	try{
		IXmlViewInformer informer = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
		IDocumentEditorOrganizer docframe = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IDocumentCache cache = (IDocumentCache)getLookup().getComponent(IDocumentCache.ROLE);
		IDocumentEditor view = null;//
		
		if(getStateEventData() != null){
			view = (IDocumentEditor)getStateEventData().get(IDocumentEditorOrganizer.DOCUMENT_EDITOR_KEY) ;
		}
		if(view == null){
			view = docframe.getActiveDocumentEditor();
		}
		IDocument doc = view.getIDocument();

		
		if(doc.isDirty()){
			int save = informer.displayConfirmation("Would you like to save your changes to "+doc.getName()+"?");
			if(save == IXmlViewInformer.YES_OPTION){
				if(getActionLookup() != null){
					getActionLookup().getAction(IFileSaveAction.ROLE).actionPerformed(null);
				}
				else{
					return;
				}
			}
			if(save == IXmlViewInformer.CANCEL_OPTION || (save != IXmlViewInformer.YES_OPTION && save != IXmlViewInformer.NO_OPTION)){
				exit_ = false;
				return;
			}
		
		}
		if(doc.getSourceFileName()!=null){
		cache.removeDocument(doc);
		}
		if(docframe.containsDocumentEditor(doc)){
			docframe.removeDocumentEditor(doc);
		}
		IXmlOutline outline = (IXmlOutline)getLookup().getComponent(IXmlOutline.ROLE);
		if(outline.getIDocument()==doc){
			IDocumentEditor ed = docframe.getActiveDocumentEditor();
			if(ed != null){
				IDocument adoc = ed.getIDocument();
				if(doc != null){
					outline.loadDocument(adoc);
				}
			}	
		}
		//docframe.removeActiveDocumentEditor();
		
	}catch(Exception e2){
		logger_.debug("Unable to close document",e2);
	}
	closeAll_ = false;
}

public void closeAll(){
	IXmlViewInformer informer = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
		IDocumentEditorOrganizer docframe = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IDocumentEditor view = docframe.getActiveDocumentEditor();
		IDocument doc = null;//view.getIDocument();
		IDocumentEditor[] eds = docframe.getDocumentEditors();
		for(int i = 0; i < eds.length; i++){
			view = eds[i];
			try{
			doc = view.getIDocument();
			if(doc == null){continue;}
		if(doc.isDirty()){
			int save = informer.displayConfirmation("Would you like to save your changes before closing "+doc.getName()+"?");
			if(save == IXmlViewInformer.YES_OPTION){
				if(getActionLookup() != null){
					getActionLookup().getAction(IFileSaveAction.ROLE).actionPerformed(null);
				}
				else{
					return;
				}
			}
			if(save == IXmlViewInformer.CANCEL_OPTION|| (save != IXmlViewInformer.YES_OPTION && save != IXmlViewInformer.NO_OPTION)){
				exit_ =false;
				System.out.println("abort...");
				return;
			}
		
		}

		docframe.removeDocumentEditor(doc);	
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		if(exit_){
			System.exit(0);	
		}
}

	
	/**
	 * Sets the closeAll.
	 * @param closeAll The closeAll to set
	 */
	public void setCloseAll(boolean closeAll) {
		closeAll_ = closeAll;
	}

	/**
	 * Sets the exit.
	 * @param exit The exit to set
	 */
	public void setExitOnClose(boolean exit) {
		exit_ = exit;
	}

}
