/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.Composable;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.xmlview.io.XmlViewFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.util.FileSystem;
import butterfly.xmlview.util.interfaces.IFileSystemHelper;
/**
 * Insert the type's description here.
 * Creation date: (8/17/2002 5:47:28 PM)
 * @author: 
 */
public class FileOpenAction extends OpenAction implements  Component, Composable,IFileOpenAction{
	private String fileDialogName = "FileDialog";
	public static String NAME = "Open";
	private static Logger logger_ = Logger.getLogger(ButterflyAction.class);
/**
 * FileOpenAction constructor comment.
 */
public FileOpenAction() {
	super();
	IFileSystemHelper help = new IFileSystemHelper() {
		/* (non-Javadoc)
		 * @see butterfly.xmlview.util.interfaces.IFileSystemHelper#resolve(java.lang.String, java.lang.String)
		 */
		public File resolve(String base, String uri) throws Exception{
			// TODO Auto-generated method stub
			return XmlViewFileSystem.resolve(base,uri);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.util.interfaces.IFileSystemHelper#loadDocument(java.io.File)
		 */
		public IDocument loadDocument(File file) {
			setFile(file);
			setShowFile(false);
			setAccessHistoryEnabled(false);
			actionPerformed(null);
			// TODO Auto-generated method stub
			return getDocument();
		}
	};
	FileSystem.setFileSystemHelper(help);
}
/**
 * FileOpenAction constructor comment.
 * @param name java.lang.String
 */
public FileOpenAction(String name) {
	super(name);
}
/**
 * FileOpenAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public FileOpenAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
}
