/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 6:31:40 PM)
 * @author: 
 */
public class FileSaveAction extends DocumentAction implements butterfly.actions.interfaces.IFileSaveAction {
	private static Logger logger_ = Logger.getLogger(FileSaveAction.class);
	private boolean rename_ = false;
	private boolean tempFile_=false;
	private File file_ = null;
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_save-16.png");
/**
 * FileSaveAction constructor comment.
 */
public FileSaveAction() {
	super(null,icon_);
}
/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 */
public FileSaveAction(String name) {
	super(name);
}


/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public FileSaveAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}

public void setFile(File f){
	file_=f;
}

/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
	IDocument doc = getDocument();
	setDocument(null);
    IXmlViewInformer informer =
        (IXmlViewInformer) getLookup().getComponent(IXmlViewInformer.ROLE);
    File file = file_;
    
    try {
        
        if (doc == null) {
            IDocumentEditorOrganizer docframe =
                (IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
            IDocumentEditor editor = (IDocumentEditor) docframe.getActiveDocumentEditor();
            
            doc = editor.getIDocument();
            logger_.debug("got :"+doc+" from the editor");
        }
       
        if (doc.getSourceFileName() != null && !shouldRename() && doc.exists() && file==null) {
            file = new File(doc.getSourceFileName());

        } else if(file == null){

            IFileChooseAction choosefile =
                (IFileChooseAction) getActionLookup().getAction(IFileChooseAction.ROLE);
            choosefile.setMode(IFileChooseAction.SAVE_MODE);
            
            choosefile.actionPerformed(null);
			if(choosefile.getSelectedFile() == null){return;}
             if (choosefile.getSelectedFile().exists()) {
                    boolean acceptover =
                        (informer.displayConfirmation(
                            "The file already exists. Are you sure you want to overwrite it?") == IXmlViewInformer.YES_OPTION);
                        
        			if(!acceptover){
	        			
	        		actionPerformed(ae);	
	        		return;}
            }

            file = choosefile.getSelectedFile();

        }

        if (file != null) {
            IContentHandlerLookup handlerlookup =
                (IContentHandlerLookup) getLookup().getComponent(IContentHandlerLookup.ROLE);

            IContentHandler handler =
                handlerlookup.getContentHandlerForFiletype(doc.getContentType());
            handler.saveDocument(file.getCanonicalPath(), doc);
            logger_.debug("File Saved.");
            doc.setDirty(false);
            doc.setExists(true);
        }
       

    } catch (Exception e) {
		StringWriter writer = new StringWriter();
		e.printStackTrace(new PrintWriter(writer));
        informer.displayError("Unable to save file\n" + writer.toString());

    }
    file_=null;
    // }
}
/**
 * Insert the method's description here.
 * Creation date: (11/21/2002 3:04:19 PM)
 * @return boolean
 */
public boolean isRename() {
	return rename_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/21/2002 3:04:19 PM)
 * @param newRename boolean
 */
public void setRename(boolean newRename) {
	rename_ = newRename;
}
/**
 * Insert the method's description here.
 * Creation date: (11/21/2002 3:04:19 PM)
 * @return boolean
 */
public boolean shouldRename() {
	return rename_;
}
}
