/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 6:31:40 PM)
 * @author: 
 */
public class FileSaveAsAction extends FileSaveAction implements butterfly.actions.interfaces.IFileSaveAction {
	private static Logger logger_ = Logger.getLogger(FileSaveAsAction.class);
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_save_as-16.png");
/**
 * FileSaveAction constructor comment.
 */
public FileSaveAsAction() {
	super(null,icon_);
}
/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 */
public FileSaveAsAction(String name) {
	super(name);
}
/**
 * FileSaveAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public FileSaveAsAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
	IDocumentCache cache = (IDocumentCache)getLookup().getComponent(IDocumentCache.ROLE);
	IDocument doc = getDocument();
	if (doc == null) {
		IDocumentEditorOrganizer docframe =
		(IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IDocumentEditor editor = (IDocumentEditor) docframe.getActiveDocumentEditor();
		
		doc = editor.getIDocument();
	}
	cache.removeDocument(doc);
	
	
    setRename(true);
	super.actionPerformed(ae);
	
	cache.cacheDocument(doc);
	
}
}
