/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.StringReader;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IGenerateSchemaAction;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.grammars.DTDGenerator;
import butterfly.xmlview.model.grammars.XSGenerator;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IXmlDocument;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class GenerateSchemaAction
	extends ButterflyAction
	implements IGenerateSchemaAction {
   
	public static final int XSD_TYPE = 0;
	public static final int DTD_TYPE=1;
	
	private int type_=DTD_TYPE;
	private AbstractValidatedDocument document_;
	private String dtd_;
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent ae) {
		if(getLookup()==null){
			ButterflyApplication.setLookups(this);
		}
		if(type_ == DTD_TYPE){
			DTDGenerator gen = new DTDGenerator();
			dtd_=gen.generateDTD((IXmlDocument)document_);
		}
		else{
			XSGenerator gen = new XSGenerator();
			String xs = gen.generateXS((IXmlDocument)document_);
			
			StringReader reader = new StringReader(xs);
			BufferedReader bin = new BufferedReader(reader);
			String line = null;
			StringBuffer xsd = new StringBuffer();
			try{
				while((line = bin.readLine())!=null){
					xsd.append(line);
					xsd.append("\n");
				}
			}catch(Exception e){}
			//XmlDocument doc = new XmlDocument(xs);
			IContentHandlerLookup chtable = (IContentHandlerLookup)getLookup().getComponent(IContentHandlerLookup.ROLE);
			IContentHandler ch = chtable.getContentHandler(IDocument.TEXT_XSD_TYPE);
			try{
				IDocument doc = ch.createDocument(xsd.toString());
				doc.setName(document_.getName()+".xsd");
				doc.setExists(false);
				ch.showDocument(doc);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IGenerateSchemaAction#setType(int)
	 */
	public void setType(int type) {
		type_=type;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IGenerateSchemaAction#setDocument(butterfly.xmlview.model.AbstractValidatedDocument)
	 */
	public void setDocument(AbstractValidatedDocument doc) {
		document_=doc;
	}

}
