package butterfly.actions;

import java.awt.event.ActionEvent;
import java.util.Hashtable;

import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author Jules White
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class GetPrefixesInUseAction extends ButterflyAction {
	private Hashtable prefixesInUse_=new Hashtable();
	private int lastCacheSize_=0;
	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		IDocumentCache cache = (IDocumentCache)getLookup().getComponent(IDocumentCache.ROLE);
		IDocument[] docs = cache.getCacheContents();
		if(docs.length >= lastCacheSize_){
		prefixesInUse_.clear();
		for(int i = 0; i < docs.length; i++){
			if(docs[i] instanceof XmlDocument){
				XmlDocument xdoc = (XmlDocument)docs[i];
				XmlDocument.NamespaceMapping[] maps = xdoc.getNamespaceMappings();
				for(int j = 0; j < maps.length; j++){
					prefixesInUse_.put(maps[j].prefix,maps[j].uri);	
				} 
			}
		}
		}
	}
	
	public Hashtable getPrefixesInUse(){
		return prefixesInUse_;
	}


	
}
