/*
 * Created on May 23, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package butterfly.actions;

import java.awt.event.ActionEvent;
import java.util.Hashtable;

import javax.swing.Icon;

import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class GoToLineAction extends ButterflyAction {
	private int line_=-1;
	private int column_=-1;
	/**
	 * 
	 */
	public GoToLineAction() {
		super();
		// TODO Auto-generated constructor stub
	}

	

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(getActionLookup()==null){
			ButterflyApplication.setLookups(this);
		}
		if(getLine() < 0){
			IXmlViewInformer inform = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
			Hashtable result= inform.displayQuery("Go to:",new String[]{"Line","Column"});
			try{
				String line = (String)result.get("Line");
				String col = (String)result.get("Column");
				if(line.equals("")){
					line = "1";
				}
				if(col.equals("")){
					col="1";
				}
				setLine(Integer.parseInt(line));
				setColumn(Integer.parseInt(col));
			}catch(Exception ex){
				return;
			}
		}
		// TODO Auto-generated method stub
		IDocumentEditorOrganizer docframe =
		(IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IDocumentEditor editor = (IDocumentEditor) docframe.getActiveDocumentEditor();
		IDocument doc = editor.getIDocument();
		if(doc != null){
			int start = getLineStart(doc,getLine());
			int end = getLineStart(doc,getLine()+1);
			if(getColumn()>-1){
				start += getColumn()-1;
			}
			editor.setSelection(start,end-start-1);
		}
		setColumn(-1);
		setLine(-1);
	}
	
	public int getLineStart(IDocument doc,int line){
		String src = doc.toString();
		int currline = 1;
		int index = 0;
		while(currline < line){
			index = src.indexOf("\n",index)+1;
			if(index < 0){
				break;
			}
			currline++;
		}
		if(currline != line){
			index = src.length();
		}
		return index;
	}
	public int getLine(IDocument doc,int pos){
		String src = doc.toString();
		int currline = 1;
		int index = 0;
		while(index < pos){
			index = src.indexOf("\n",index)+1;
			if(index < 0 || index > pos){
				break;
			}
			currline++;
		}
		
		return currline;
	}

	/**
	 * @return Returns the column_.
	 */
	public int getColumn() {
		return column_;
	}

	/**
	 * @param column_ The column_ to set.
	 */
	public void setColumn(int column) {
		this.column_ = column;
	}

	/**
	 * @return Returns the line_.
	 */
	public int getLine() {
		return line_;
	}

	/**
	 * @param line_ The line_ to set.
	 */
	public void setLine(int line) {
		this.line_ = line;
	}

}
