/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.awt.event.ActionEvent;

import javax.swing.Icon;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.model.WriteProtectionMarker;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IXmlDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class LockTagsAction extends ButterflyAction {

	/**
	 * Constructor for LockTagsAction.
	 */
	public LockTagsAction() {
		super();
	}

	/**
	 * Constructor for LockTagsAction.
	 * @param name
	 */
	public LockTagsAction(String name) {
		super(name);
	}

	/**
	 * Constructor for LockTagsAction.
	 * @param name
	 * @param icon
	 */
	public LockTagsAction(String name, Icon icon) {
		super(name, icon);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		IDocumentEditorOrganizer org = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IDocumentEditor edit = org.getActiveDocumentEditor();
		if(edit == null){return;}
		IDocument doc = edit.getIDocument();
		if(doc instanceof IXmlDocument){
		INode node = doc.getRoot();
		protect(node);
		
		}
	}
	
	public void protect(INode node){
		if(node instanceof IElement){
				IMarker[] markers = node.getMarkersOfType(WriteProtectionMarker.WRITE_PROTECTED_MARKER_TYPE);
				if(markers != null){
					if(markers.length > 0){
						node.removeMarker(markers[0]);	
					}	
					else{
						node.addMarker(new WriteProtectionMarker());	
					}					
				}
				else{
						node.addMarker(new WriteProtectionMarker());	
					}	
				
			}
			for(int i = 0; i < node.childCount(); i++){
				protect(node.childAt(i));	
			}	
	}

	
}
