/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import butterfly.actions.contenthandlers.interfaces.IContentType;
import butterfly.actions.contenthandlers.interfaces.IContentTypeLookup;
import butterfly.xmlview.gui.NewFileWizard;
import butterfly.xmlview.gui.interfaces.IButterflyDesktop;

public class NewFileAction extends ButterflyAction {
	public static final ImageIcon icon = new ImageIcon("icons/stock_new-16.png");
	private NewFileWizard wizard_;
	private String type_ = null;
	/**
	 * Constructor for NewFileAction.
	 */
	public NewFileAction() {
		super(null,icon);
		
	}

	


	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(wizard_==null){
			IButterflyDesktop pane = (IButterflyDesktop)getLookup().getComponent(IButterflyDesktop.ROLE);
			wizard_ = new NewFileWizard(pane.getApplicationFrame(),true);	
		}
		if(getType() != null){
			IContentTypeLookup lookup = (IContentTypeLookup)getLookup().getComponent(IContentTypeLookup.ROLE);	
			IContentType type = lookup.getContentType(getType());
			setType(null);
			wizard_.show(type);
		}
		else{
			//wizard.setSize(500,300);
			wizard_.show();
		}
		
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {
		super.requestComponents();
		
	}

	/**
	 * Returns the type.
	 * @return String
	 */
	public String getType() {
		return type_;
	}

	/**
	 * Sets the type.
	 * @param type The type to set
	 */
	public void setType(String type) {
		type_ = type;
	}

}
