
/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import javax.swing.ImageIcon;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (9/11/2002 5:01:31 PM)
 * @author: 
 */
public class NewXmlDocumentAction extends ButterflyAction {
	private static int newDocCount_ = 1;
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_new-xml-16.png");
/**
 * NewXmlDocumentAction constructor comment.
 */
public NewXmlDocumentAction() {
	super(null,icon_);
}
/**
 * NewXmlDocumentAction constructor comment.
 * @param name java.lang.String
 */
public NewXmlDocumentAction(String name) {
	super(name);
}
/**
 * NewXmlDocumentAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public NewXmlDocumentAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent e) {
	try{
		//IXmlEditor editor = (IXmlEditor)getComponentManager().lookup(IXmlEditor.ROLE);//(IXmlEditor)getLookup().getComponent("XmlEditor");
  		//IFileOpenAction open = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);
		//open.actionPerformed(null);
		
		//IDocument vdoc = open.getDocument();
		//ICreateDocumentStubAction create = (ICreateDocumentStubAction)getActionLookup().getAction(ICreateDocumentStubAction.ROLE);
		//create.setDocument(vdoc);
		
		//IXmlViewInformer informer = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
		//String root = informer.displayQuery("Which element would you like to be the root of the document?");
		//create.setRootElement(root);
		//create.actionPerformed(null);
		//String stub = create.getStub();
  		IContentHandlerLookup lookup = (IContentHandlerLookup)getLookup().getComponent(IContentHandlerLookup.ROLE);
		IFileSystem filesystem = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
		IContentHandler handler = lookup.getContentHandler(IDocument.TEXT_XML_TYPE);
		IDocument doc = handler.createDocument(null);
		//doc.setName("Docment"+newDocCount_+".xml");
		File nf = filesystem.createNewFile("xml");
		doc.setName(nf.getName());
		doc.setSourceFileName(nf.getAbsolutePath());
		IDocumentCache cache = (IDocumentCache)getLookup().getComponent(IDocumentCache.ROLE);
		if(cache != null){
			cache.cacheDocument(doc);	
		}
		newDocCount_++;
		handler.showDocument(doc);
	}catch(Exception e2){
		e2.printStackTrace();
	}	
}
}
