/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.io.interfaces.IDocumentAccessHistory;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/16/2002 11:55:13 AM)
 * @author: 
 */
public class OpenAction extends ButterflyAction {
	public String OPEN_FILE_STATE_EVENT_ID = "file-opened";
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_open-16.png");
	private static Logger logger_ = Logger.getLogger(OpenAction.class);
	private File file_;
	private boolean showFile_ = true;
	private IDocument document_;
	private boolean cacheEnabled_ = true;
	private String approveText_ = "Open";
	private static String defaultApproveText_ = "Open";
	private boolean accessHistoryEnabled_ = true;
	private Exception error_;
	private static OpenAction instance_;
	private String[] filters_;
	private String[] descriptions_;
	private String openAs_=null;
	private int mode_ = IContentHandler.READ_WRITE;
/**
 * OpenAction constructor comment.
 */
public OpenAction() {
	super(null,icon_);
}
/**
 * OpenAction constructor comment.
 * @param name java.lang.String
 */
public OpenAction(String name) {
	super(name);
}
/**
 * OpenAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public OpenAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:17:03 PM)
 * @return boolean
 */
public boolean accessHistoryIsEnabled() {
	return accessHistoryEnabled_;
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
	document_ = null;
    File file = null;
    error_ = null;
    if (file_ == null) {
        IFileChooseAction choosefile =
            (IFileChooseAction) getActionLookup().getAction(IFileChooseAction.ROLE);
        if(filters_!=null){
        	choosefile.setFileFilters(filters_,descriptions_);	
        }
        choosefile.setMode(IFileChooseAction.OPEN_MODE);
        choosefile.setApproveText(approveText_);
        choosefile.actionPerformed(null);
        file = choosefile.getSelectedFile();
    } else {
        file = file_;
    }

    if (file != null) {

        try {
        	logger_.debug("OpenAction.actionPerformed()");
	        String fext = file.getName().substring(file.getName().lastIndexOf("."));
			IDocument doc = null;
			logger_.debug("component lookup is:"+getLookup());
            IContentHandlerLookup handlerlookup =
                (IContentHandlerLookup) getLookup().getComponent(IContentHandlerLookup.ROLE);
            logger_.debug("looking up the content handler for the file extension: " + fext);
            IContentHandler handler =null;
            
            if(openAs_==null){
            	handler=handlerlookup.getContentHandlerForFiletype(fext);
            }
            else{
            	handler=handlerlookup.getContentHandler(openAs_);
            }
           	IFileSystem filesystem = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
	        IDocumentCache cache = (IDocumentCache)getLookup().getComponent(IDocumentCache.ROLE);
	        if(cache != null && cacheIsEnabled() && openAs_==null){
	        	logger_.debug("looking in the cache for:"+file.getPath());
	        	logger_.debug("is new file="+filesystem.isNewFile(file));
				
				if(filesystem.isNewFile(file)){
					
					doc = cache.getDocument(file.getPath());
				}else{
					doc = cache.getDocument(file.getCanonicalPath());
				}
	        }
	        else{
	        	logger_.debug("cache disabled");	
	        }
	      	if(doc == null){  
	      		Object key = null;   
	      		IXmlViewInformer inform=null;
	      		//if(showFile_){
	      			//inform = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
	      	//		ButterflyDesktop dtop = (ButterflyDesktop)getLookup().getComponent(IButterflyDesktop.ROLE);
	      	//		Container c = dtop.getParent();  // get the window's content pane
	      	//		c.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	      			//key =inform.displayTransientMessage("Loading Document...");
	      	//	}
	      		boolean show = showFile_;
            	doc = handler.loadDocument(file.getCanonicalPath());
            	showFile_=show;
           // 	c.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            	if(cache != null && cacheIsEnabled()){
            		cache.cacheDocument(doc);
            	}
            	if(key!=null){
            		//inform.closeWindow(key);	
            	}
	      	}
	      	document_ = doc;
	      	logger_.debug("open document successful="+(document_ != null));
            if (showFile_) {
                handler.showDocument(doc,mode_);
            }
            if(accessHistoryIsEnabled()){
				IDocumentAccessHistory hist = (IDocumentAccessHistory)getLookup().getComponent(IDocumentAccessHistory.ROLE);
				if(hist != null){
					hist.documentOpened(doc);
				}
            }
            
        } catch (Exception e) {
	        e.printStackTrace();
            logger_.warn(e);
            error_ = e;
        }
    }
    approveText_ = defaultApproveText_;
    file_ = null;
    showFile_ = true;
    accessHistoryEnabled_=true;
    filters_=null;
    descriptions_=null;
    openAs_=null;
    mode_=IContentHandler.READ_WRITE;
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:06:03 PM)
 * @return boolean
 */
public boolean cacheIsEnabled() {
	return cacheEnabled_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:56:17 PM)
 * @return java.lang.String
 */
public java.lang.String getApproveText() {
	return approveText_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 9:06:36 AM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:57:01 AM)
 * @return java.io.File
 */
public java.io.File getFile() {
	return file_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:17:03 PM)
 * @param newAccessHistoryEnabled boolean
 */
public void setAccessHistoryEnabled(boolean newAccessHistoryEnabled) {
	accessHistoryEnabled_ = newAccessHistoryEnabled;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:56:17 PM)
 * @param newApproveText java.lang.String
 */
public void setApproveText(java.lang.String newApproveText) {
	approveText_ = newApproveText;
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:06:03 PM)
 * @param newCacheEnabled boolean
 */
public void setCacheEnabled(boolean newCacheEnabled) {
	cacheEnabled_ = newCacheEnabled;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:57:01 AM)
 * @param newFile java.io.File
 */
public void setFile(java.io.File newFile) {
	file_ = newFile;
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 9:09:45 PM)
 * @param newFileName java.lang.String
 */
public void setFileName(java.lang.String newFileName) {
	file_ = new File(newFileName);
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 9:06:36 AM)
 * @param newShowFile boolean
 */
public void setShowFile(boolean newShowFile) {
	showFile_ = newShowFile;
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 9:06:36 AM)
 * @return boolean
 */
public boolean willShowFile() {
	return showFile_;
}
	/**
	 * Sets the document.
	 * @param document The document to set
	 */
	public void setDocument(IDocument document) {
		document_ = document;
	}

	/**
	 * Returns the error.
	 * @return Exception
	 */
	public Exception getError() {
		return error_;
	}

	/**
	 * Sets the error.
	 * @param error The error to set
	 */
	public void setError(Exception error) {
		error_ = error;
	}

	public void setFileFilters(String[] exts, String[] descs){
		filters_ = exts;
		descriptions_=descs;
	}
	/**
	 * @return Returns the mode_.
	 */
	public int getMode() {
		return mode_;
	}

	/**
	 * @param mode_ The mode_ to set.
	 */
	public void setMode(int mode) {
		this.mode_ = mode;
	}

	/**
	 * @param openAs_ The openAs_ to set.
	 */
	public void setTypeToOpenAs(String openAs) {
		this.openAs_ = openAs;
	}

}
