/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;

import butterfly.actions.interfaces.IOpenInBrowserAction;
import butterfly.xmlview.gui.Browser;
import butterfly.xmlview.gui.interfaces.IBrowserManager;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class OpenInBrowserAction
	extends ButterflyAction
	implements IOpenInBrowserAction,Configurable {
//    class Browser {
//    	public String name;
//    	public String command;
//    	public Browser(String bname, String lcommand){
//    		name=bname;
//    		command=lcommand;
//    	}
//    }
    public void configure(Configuration conf){}
    class BrowserLauncher extends Thread{
    	private String command_;
    	private boolean cleanupOnExit_;
    	private File file_;
    	
    	public BrowserLauncher(String cmd,File file,boolean cup){
    		command_=cmd;
    		cleanupOnExit_=cup;
    		file_=file;
    	}
    	
    	public void run(){
    		try{
    		Process p= Runtime.getRuntime().exec(command_+" "+file_.getAbsolutePath());
    		p.waitFor();
    		if(cleanupOnExit_){
    			file_.delete();
    		}
    		}catch(Exception e){
    			e.printStackTrace();
    		}
    	}
    }
    
    public static final String BROWSER_NAME_ATTRIBUTE  = "name";
    public static final String BROWSER_COMMAND_ATTRIBUTE = "command";
    
    private String browser_;
    private String defaultBrowser_;
    private Hashtable browsers_ = new Hashtable(1);
    private File file_;
    private IDocument document_;
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		boolean cup=false;
		if(document_!=null){
			if(document_.isDirty() || !document_.exists()){
				try{
				IFileSystem fs = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
				file_ = fs.saveTempFile(document_.getName()+".html",document_.toString());
				cup = true;
				}catch(Exception ex){
					ex.printStackTrace();
				}
			}
			else{
				file_ = new File(document_.getSourceFileName());
			}
		}
		if(file_ != null){
			Browser b = getBrowser(browser_);
			if(b != null){
				String command = b.command;
				BrowserLauncher bl = new BrowserLauncher(command,file_,cup);
				bl.start();
			}
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IOpenInBrowserAction#setDocument(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public void setDocument(IDocument doc) {
		document_=doc;
		file_=null;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IOpenInBrowserAction#setBrowser(java.lang.String)
	 */
	public void setBrowser(String browser) {
		browser_=browser;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IFileOpenAction#getDocument()
	 */
	public IDocument getDocument() {
		return document_;
	}

	
	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IOpenInBrowserAction#addBrowser(java.lang.String, java.lang.String)
	 */
	public void addBrowser(String name, String launchcommand) {
		Browser b = new Browser(name,launchcommand);
		browsers_.put(name,b);
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IOpenInBrowserAction#getBrowserNames()
	 */
	public String[] getBrowserNames() {
		return getBrowserManager().getBrowserNames();
		//return (String[])browsers_.keySet().toArray(new String[0]);
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IOpenInBrowserAction#removeBrowser(java.lang.String)
	 */
	public void removeBrowser(String name) {
		browsers_.remove(name);

	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IFileOpenAction#setFile(java.io.File)
	 */
	public void setFile(File file) {
		file_=file;
		document_=null;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IFileOpenAction#setShowFile(boolean)
	 */
	public void setShowFile(boolean show) {
		

	}
	
	protected IBrowserManager getBrowserManager(){
		return (IBrowserManager)getLookup().getComponent(IBrowserManager.ROLE);
	}
	
	protected Browser getBrowser(String name){
		return getBrowserManager().getBrowser(name);
	}

	/* (non-Javadoc)
	 * @see org.apache.avalon.framework.configuration.Configurable#configure(org.apache.avalon.framework.configuration.Configuration)
	 */
//	public void configure(Configuration arg0) throws ConfigurationException {
//		Configuration[] children = arg0.getChildren();
//		
//		String name = null;
//		String cmd = null;
//		for(int i = 0; i < children.length; i++){
//			name = children[i].getAttribute(BROWSER_NAME_ATTRIBUTE,"Unknown Browser");
//			cmd = children[i].getAttribute(BROWSER_COMMAND_ATTRIBUTE,"");
//			addBrowser(name,cmd);
//		}
//	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IFileOpenAction#setAccessHistoryEnabled(boolean)
	 */
	public void setAccessHistoryEnabled(boolean newAccessHistoryEnabled) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IFileOpenAction#setTypeToOpenAs(java.lang.String)
	 */
	public void setTypeToOpenAs(String type) {
		// TODO Auto-generated method stub

	}

}
