/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.io.File;

import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IFileOpenAction;

public class ProjectFileSelectionAction extends ButterflyAction {
	private static Logger logger_ = Logger.getLogger(ProjectFileSelectionAction.class);
/**
 * ProjectFileSelectionAction constructor comment.
 */
public ProjectFileSelectionAction() {
	super();
}
/**
 * ProjectFileSelectionAction constructor comment.
 * @param name java.lang.String
 */
public ProjectFileSelectionAction(String name) {
	super(name);
}
/**
 * ProjectFileSelectionAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public ProjectFileSelectionAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
	if(getStateEventData() != null){
		if(getStateEventData().get("selected-file") != null){
			String path = (String)getStateEventData().get("selected-file");
			try{
				File file = new File(path);
				IFileOpenAction open = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);
				open.setFile(file);
				open.actionPerformed(null);
			}catch(Exception e){
				logger_.warn("unable to open selected project file: ",e);
			}
		}
	}
	
}
}
