/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.awt.event.ActionEvent;

import butterfly.actions.interfaces.IShowJumpstartAction;
import butterfly.xmlview.gui.Jumpstart;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/23/2002 8:04:49 PM)
 * @author: 
 */
public class ShowJumpstartPageAction extends ButterflyAction implements IShowJumpstartAction{
	private String jumpstartPage_ = "Jumpstart.htm";
/**
 * ShowJumpstartPage constructor comment.
 */
public ShowJumpstartPageAction() {
	super();
}
/**
 * ShowJumpstartPage constructor comment.
 * @param name java.lang.String
 */
public ShowJumpstartPageAction(String name) {
	super(name);
}
/**
 * ShowJumpstartPage constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public ShowJumpstartPageAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(ActionEvent e) {
    try {
    	/*
        IFileOpenAction open =
            (IFileOpenAction) getActionLookup().getAction(IFileOpenAction.ROLE);
        File file = new File(jumpstartPage_);
        open.setFile(file);
        open.setShowFile(false);
        open.actionPerformed(null);
        IDocument doc = open.getDocument();
        IDocumentAccessHistory hist =
            (IDocumentAccessHistory) getLookup().getComponent(IDocumentAccessHistory.ROLE);
        String[] files = hist.getDocumentList();
        int prjcount = 1;
        int filecount = 1;
        String doclist = "<b>Recent Documents:</b><br>";
        String prjlist = "<b>Recent Projects:</b><br>";
        for (int i = 0; i < files.length; i++) {
            String curr = files[i];
            if (!(curr.toLowerCase().indexOf("jumpstart") > -1)) {
                if (curr.endsWith(".bfp")) {
                    prjlist += "<a href=\"http://www.butterfly.action/butterfly.actions.interfaces.IFileOpenAction?FileName="+curr+"\">"+prjcount + ". " + curr + "</a><br>";
                    prjcount++;
                } else {
                    doclist += "<a href=\"http://www.butterfly.action/butterfly.actions.interfaces.IFileOpenAction?FileName="+curr+"\">"+filecount + ". " + curr + "</a><br>";
                    filecount++;
                }
            }
            
        }
        BasicDocument bdoc = new BasicDocument();
        bdoc.setText("The Jumpstart page allows you to quickly open your most frequently accessed files. It also lets you create popular file types with a single click.");
        
        doc.setName("Jumpstart");
        Hashtable data = new Hashtable();
        data.put("recent-projects", prjlist);
        data.put("recent-documents", doclist);
        */
    	Jumpstart jump = (Jumpstart)getLookup().getComponent("butterfly.xmlview.gui.Jumpstart");
    	//JumpstartPage jump = new JumpstartPage(getLookup(),getActionLookup());
    	IDocument doc = jump.getIDocument();
        IDocumentEditorOrganizer docframe =
            (IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
        //System.out.println("doc"+doc);
        if (!docframe.containsDocumentEditor(doc)) {
            //IXmlViewBrowserPane pane = (IXmlViewBrowserPane)getComponentManager().lookup(IXmlViewBrowserPane.ROLE);
            //pane.loadDocument(doc);
//            IHtmlDisplayPane editor =
//                (IHtmlDisplayPane) getComponentManager().lookup(IHtmlDisplayPane.ROLE);
//            if (editor instanceof IActionRequester) {
//                ((IActionRequester) editor).setActionLookup(getActionLookup());
//            }
//            editor.setHtml(doc.toString(), data);
//            editor.loadDocument(bdoc);
            if (!docframe.containsDocumentEditor(doc)) {
                docframe.addDocumentEditor(doc, jump);
            }
        }
        doc.setDirty(false);
        docframe.showDocumentEditor(doc);

    } catch (Exception e2) {
        e2.printStackTrace();
    }
}
}
