/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions;

import java.io.File;
import java.util.Vector;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;

import butterfly.actions.interfaces.IFileOpenAction;
/**
 * Insert the type's description here.
 * Creation date: (11/22/2002 2:02:13 PM)
 * @author: 
 */
public class StateRestorationAction extends ButterflyAction implements butterfly.actions.interfaces.IStateRestorationAction,Configurable{
	private Vector documents_ = new Vector();
	private Configuration configuration_;
	public static final String PATH_ATTRIBUTE = "path";
/**
 * StateRestorationAction constructor comment.
 */
public StateRestorationAction() {
	super();
}
/**
 * StateRestorationAction constructor comment.
 * @param name java.lang.String
 */
public StateRestorationAction(String name) {
	super(name);
}
/**
 * StateRestorationAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public StateRestorationAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 2:02:13 PM)
 * @param ae java.awt.event.ActionEvent
 */
public void actionPerformed(java.awt.event.ActionEvent ae) {
	try{
		IFileOpenAction open = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);

		for(int i = 0; i < documents_.size(); i++){
			File file = (File)documents_.elementAt(i);
			open.setFile(file);
			open.actionPerformed(null);
		}
	}catch(Exception e){
		e.printStackTrace();
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 2:04:40 PM)
 * @param file java.io.File
 */
public void addFileToOpen(java.io.File file) {
	documents_.add(file);	
}
/**
 * configure method comment.
 */
public void configure(org.apache.avalon.framework.configuration.Configuration arg1) throws org.apache.avalon.framework.configuration.ConfigurationException {
	if(configuration_ == null){
		configuration_ = arg1;
		return;
	}

	Configuration[] files = arg1.getChildren();
	for(int i = 0; i < files.length; i++){
		String path = files[i].getAttribute(PATH_ATTRIBUTE);
		File file = new File(path);
		addFileToOpen(file);
	}

	//actionPerformed(null);
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 2:18:21 PM)
 */
public void requestActions() {
	try{
		configure(configuration_);
	}catch(Exception e){
		e.printStackTrace();
	}
}
}
