/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.awt.event.ActionEvent;

import javax.swing.Icon;

/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
import org.apache.log4j.Logger;


import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlOutline;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class UpdateOutlineAction extends ButterflyAction {
	private Logger logger_ = Logger.getLogger(UpdateOutlineAction.class);
	/**
	 * Constructor for UpdateOutlineAction.
	 */
	public UpdateOutlineAction() {
		super();
	}

	/**
	 * Constructor for UpdateOutlineAction.
	 * @param name
	 */
	public UpdateOutlineAction(String name) {
		super(name);
	}

	/**
	 * Constructor for UpdateOutlineAction.
	 * @param name
	 * @param icon
	 */
	public UpdateOutlineAction(String name, Icon icon) {
		super(name, icon);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		//System.out.println("updating outline...");
		//Profiler.start("UpdateOutlineAction.actionPerformed()");
		IDocumentEditorOrganizer org = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
		IXmlOutline outline = (IXmlOutline)getLookup().getComponent(IXmlOutline.ROLE);
		if(org != null && outline != null){
			IDocumentEditor ed = org.getActiveDocumentEditor();
			if(ed != null){
				IDocument doc = ed.getIDocument();
				if(doc != null){
					logger_.debug("Outline updated");
					outline.loadDocument(doc);
				}
			}	
		}
		//Profiler.end("UpdateOutlineAction.actionPerformed()");
	}

}
