/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions;

import butterfly.xmlview.model.validation.interfaces.IValidationError;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.model.validation.interfaces.IXmlValidator;
import butterfly.xmlview.gui.interfaces.IValidationPane;
import org.apache.log4j.Logger;
/**
 
 * @author: 
 */
public class XmlSyntacticalCheckAction extends ButterflyAction {
	private static Logger logger_ = Logger.getLogger(XmlSyntacticalCheckAction.class);
/**
 * XmlValidationAction constructor comment.
 */
public XmlSyntacticalCheckAction() {
	super();
}
/**
 * XmlValidationAction constructor comment.
 * @param name java.lang.String
 */
public XmlSyntacticalCheckAction(String name) {
	super(name);
}
/**
 * XmlValidationAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public XmlSyntacticalCheckAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * Invoked when an action occurs.
 */
public void actionPerformed(java.awt.event.ActionEvent e) {
    try {
        IValidationPane pane =
            (IValidationPane) getLookup().getComponent(IValidationPane.ROLE);
        IXmlValidator validator =
            (IXmlValidator) getLookup().getComponent(IXmlValidator.ROLE);
        IDocumentEditorOrganizer docframe =
            (IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
        IXmlViewInformer informer =
            (IXmlViewInformer) getLookup().getComponent(IXmlViewInformer.ROLE);
        IDocumentEditor docview = docframe.getActiveDocumentEditor();
		String xml = docview.getIDocument().toString();
		IValidationError[] errors = validator.validate(xml,null);
		pane.setValidationErrors(errors);
    } catch (Exception ex) {
        logger_.debug("Unable to validate XML.", ex);
    }
}
}
