/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.awt.event.ActionEvent;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.IValueNode;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class XmlTidyAction extends DocumentAction {
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_tidy-16.png");
	private StringBuffer indent_ = new StringBuffer("");
	private String increment_ = "  ";
	/**
	 * Constructor for XmlTidyAction.
	 */
	public XmlTidyAction() {
		super(null,icon_);
	}

	/**
	 * Constructor for XmlTidyAction.
	 * @param name
	 */
	public XmlTidyAction(String name) {
		super(name);
	}

	/**
	 * Constructor for XmlTidyAction.
	 * @param name
	 * @param icon
	 */
	public XmlTidyAction(String name, Icon icon) {
		super(name, icon);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		
		if (getDocument() == null) {
            IDocumentEditorOrganizer docframe =
                (IDocumentEditorOrganizer) getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
            IDocumentEditor editor = (IDocumentEditor) docframe.getActiveDocumentEditor();
            
            setDocument(editor.getIDocument());
           // logger_.debug("got :"+doc+" from the editor");
        }
		if(getDocument() instanceof XmlDocument){
			StringBuffer buffer = new StringBuffer(getDocument().toString().length());
			INode curr = getDocument().getRoot();
			for(int i = 0; i < curr.childCount(); i++){
				visitNode(buffer,curr.childAt(i));	
				buffer.append("\n");
			}
			XmlDocument doc = (XmlDocument)getDocument();
			//StringBuffer buff = doc.getSourceBuffer();
			//buff.delete(0,buff.length());
			//buff.append(buffer);
			//doc.refreshSource();
			doc.setSource(buffer.toString(),false);
		}
	}
	
//	public void tidy(INode node){
//		int start = node.getStart();
//		int length = node.getLength();
//		Strin	
//	}
	
	public void visitNode(StringBuffer buffer, INode node){
		if(!(node instanceof IValueNode)){
			buffer.append(indent_);
		}
		int start = buffer.length();
	
		String x=null;
		if(!(node instanceof IScratchTag)){
			x=node.toString();
			buffer.append(x);
		}
		else{
			x=((IScratchTag)node).getText();
			buffer.append(x);
		}
		if(node instanceof ISourceNode){
			ISourceNode sn = (ISourceNode)node;
			sn.setStart(start);
			sn.setLength(x.length());
		}
		indent_.append(increment_);
		boolean addindent = false;
		for(int i = 0; i < node.childCount(); i++){
			if(!(node.childAt(i) instanceof IValueNode)){
				buffer.append("\n");	
			}
			visitNode(buffer,node.childAt(i));
			if(!(node.childAt(i) instanceof IValueNode) && i == node.childCount()-1){
				addindent = true;	
			}	
		}
		indent_.delete(indent_.length()-increment_.length(),indent_.length());
		if(addindent){
			buffer.append("\n"+indent_);	
		}
		int end = buffer.length();
		if(node instanceof ISourceElement){
			ISourceElement sel = ((ISourceElement)node);
			if(sel.getEndTagStart() > -1){
				buffer.append(sel.toEndString());
				sel.setEndTagStart(end);
				sel.setEndTagLength(sel.toEndString().length());
			}				
		}
		
	}
	

}
