/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;

import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import butterfly.xmlview.gui.interfaces.IButterflyDesktop;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IFileDialog;
import butterfly.xmlview.gui.interfaces.IXmlViewBrowserPane;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.BasicDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.xslt.interfaces.IXmlViewXsltTransformer;
/**
 * Insert the type's description here.
 * Creation date: (8/19/2002 6:16:46 PM)
 * @author: 
 */
public class XsltTransformAction extends ButterflyAction {
	private static Logger logger_ = Logger.getLogger(XsltTransformAction.class);
	private static final ImageIcon icon_ = new ImageIcon("icons/stock_play_xsl-16.png");
/**
 * XsltTransformAction constructor comment.
 */
public XsltTransformAction() {
	super(null,icon_);
}
/**
 * XsltTransformAction constructor comment.
 * @param name java.lang.String
 */
public XsltTransformAction(String name) {
	super(name);
}
/**
 * XsltTransformAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public XsltTransformAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
/**
 * actionPerformed method comment.
 */
public void actionPerformed(java.awt.event.ActionEvent arg1) {
    try {
	    IXmlViewInformer informer = (IXmlViewInformer)getLookup().getComponent(IXmlViewInformer.ROLE);
		
        IXmlViewXsltTransformer transformer =
            (IXmlViewXsltTransformer) getComponentManager().lookup(
                IXmlViewXsltTransformer.ROLE);
        //IXmlEditor editor = (IXmlEditor) getLookup().getComponent(IXmlEditor.ROLE);

        //IXmlDocument doc = editor.getXmlModel();
        //String xml = doc.toXml();
        IDocumentEditorOrganizer docframe = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
        IDocumentEditor view = docframe.getActiveDocumentEditor();
        IDocument doc = view.getIDocument();
        if(doc == null){
			informer.displayError("There is not an open document to apply the transformation to.");
			return;
        }
        String xml = doc.toString();

        IFileDialog chooser = (IFileDialog) getLookup().getComponent(IFileDialog.ROLE);
       	chooser.setApproveText("Transform");
        int accept =
            chooser.showOpenDialog((Component) getLookup().getComponent(IButterflyDesktop.ROLE));
        if (accept == IFileDialog.APPROVE_OPTION) {
            FileReader freader = new FileReader(chooser.getSelectedFile());
            BufferedReader reader = new BufferedReader(freader);
            String line = "";
            StringBuffer contents = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                contents.append(line);
                contents.append("\n");
            }
            String xsl = contents.toString();

			logger_.debug("Starting transformation...");
            
            String output = transformer.transform(xml,xsl);

           //	logger_.debug("out: "+output);
			IXmlViewBrowserPane pane = (IXmlViewBrowserPane)getComponentManager().lookup(IXmlViewBrowserPane.ROLE);
			BasicDocument tdoc = new BasicDocument(IDocument.TEXT_HTML_TYPE);
			tdoc.setText(output);
			pane.loadDocument(tdoc);
			//pane.setHtml(output);
			String docname = "XSLTransformation: "+doc.getSourceFileName();
			tdoc.setName(docname);
			docframe.addDocumentEditor(tdoc,(IDocumentEditor)pane);
			docframe.showDocumentEditor(tdoc);
        }
        else{
			logger_.debug("Transformation canceled");
        }

    } catch (Exception e) {
        logger_.warn("Unable to complete the transformation action.",e);
    }

}
}
