/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;


import java.io.File;
import java.util.Properties;

import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.actions.ButterflyAction;
import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentType;
import butterfly.actions.contenthandlers.interfaces.IParameterValidationError;

/**

 * @author: 
 */
public abstract class AbstractContentHandler extends ButterflyAction implements IContentHandler{
	//private String type_;
	private IContentType contentType_;
/**
 * AbstractContentHandler constructor comment.
 */
public AbstractContentHandler(String type) {
	super();
	contentType_ = ContentType.getContentType(type);
}

public AbstractContentHandler(IContentType type) {
	super();
	contentType_ = type;
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent e) {}
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:03:56 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public boolean canHandleContent(IContentType type) {
	return (contentType_.getName().equals(type.getName()));
}
public boolean canHandleContent(String type) {
	return (contentType_.getName().equals(type));
}
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:03:56 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public IContentType getPreferredContentType() {
	return contentType_;
}
public IDocument loadDocument(String filename) throws Exception{
    
	IFileSystem loader = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
	 String contents = loader.readFile(new File(filename));
	 IDocument doc = createDocument(contents);
	 doc.setSourceFileName(filename);
	 return doc;
}
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 3:46:55 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public void saveDocument(String savename, IDocument doc) throws java.lang.Exception {
	 	IFileSystem loader = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
	 
  	
	 	loader.saveFile(savename, doc.toString());
        
		
}
	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(String, Properties)
	 */
	public IDocument createDocument(String content, Properties props)
		throws Exception {
		return createDocument(content);
	}
	
	public IParameterValidationError[] validateParams(Properties props){
		return null;	
	}

}
