/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.util.Hashtable;

import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.contenthandlers.interfaces.IContentType;
import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (9/19/2002 11:46:07 PM)
 * @author: 
 */
public class ContentHandlerLookup implements IComponent,IContentHandlerLookup,Configurable,Composable,IActionRequester,IComponentRequester{
	private Hashtable contentHandlers_;
	private ComponentManager componentManager_;
	private IActionLookup actionLookup_;
	private IComponentLookup componentLookup_;
	private Configuration configuration_;
	private IContentHandler defaultHandler_;
	private static Logger logger_ = Logger.getLogger(ContentHandlerLookup.class);

	public static final String CONTENT_HANDLERS = "content-handlers";
	public static final String CONTENT_HANDLER_ROLE = "role";
	public static final String CONTENT_HANDLER_TYPE = "content-type";
	public static final String CONTENT_HANDLER_FILE_EXTS = "file-extensions";
	public static final String DEFAULT_CONTENT_HANDLER = "default";
/**
 * ContentHandlerLookup constructor comment.
 */
public ContentHandlerLookup() {
	super();
	contentHandlers_ = new Hashtable(5);
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:48:20 PM)
 * @param h butterfly.actions.contenthandlers.interfaces.IContentHandler
 */
public void addContentHandler(butterfly.actions.contenthandlers.interfaces.IContentHandler h) {
	logger_.debug("adding the content handler for:"+h.getPreferredContentType().getName());
	contentHandlers_.put(h.getPreferredContentType().getName(),h);	
}
/**
 * compose method comment.
 */
public void compose(ComponentManager arg1) throws ComponentException {
	componentManager_ = arg1;	
}
/**
 * configure method comment.
 */
public void configure(Configuration conf) throws ConfigurationException {
	
	if(configuration_ == null){
		configuration_ = conf;
	}
	if(actionLookup_ == null || componentLookup_ == null || configuration_ == null || componentManager_ == null){
		return;
	}
	Configuration handlers = configuration_.getChild(CONTENT_HANDLERS);
	String defaultstr = handlers.getAttribute(DEFAULT_CONTENT_HANDLER);

	Configuration[] chandlers = handlers.getChildren();
	String role = null;
	String type = null;
	String exts = null;
	for(int i = 0; i < chandlers.length; i++){
		try{
		role = chandlers[i].getAttribute(CONTENT_HANDLER_ROLE);
		
		
		IContentType ct = ContentType.getContentType(chandlers[i]);
		
		
		IContentHandler handler = (IContentHandler)componentManager_.lookup(role);
		

		if(role.equals(defaultstr)){
			defaultHandler_ = handler;
			logger_.debug("default content handler set to:"+defaultHandler_);
		}

		if(handler instanceof IActionRequester){
			((IActionRequester)handler).setActionLookup(actionLookup_);
			((IActionRequester)handler).requestActions();
		}
		if(handler instanceof IComponentRequester){
			((IComponentRequester)handler).setComponentLookup(componentLookup_);
			((IComponentRequester)handler).requestComponents();
		}

		if(handler.getPreferredContentType() != null){
			addContentHandler(handler);
		}
		
		
		String[] filexts = ct.getFileExtensions();
		for(int j = 0; j<filexts.length; j++){
			logger_.debug("registering:"+handler+" with fileext:"+filexts[j]);
			registerContentHandler(filexts[j],handler);
		}
		
		}catch(Exception e){
			logger_.warn("Unable to load content-handler for role:"+role+" to handle:"+type+" and files of type:"+exts,e);
		}
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:48:20 PM)
 * @return butterfly.actions.contenthandlers.interfaces.IContentHandler
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public IContentHandler getContentHandler(IDocument doc) {
	IContentHandler dochandler = getContentHandler(doc);
	if(dochandler == null){
		IContentHandler[] handlers = (IContentHandler[])contentHandlers_.values().toArray(new IContentHandler[0]);
		for(int i = 0; i < handlers.length; i++){
			if(handlers[i].canHandleContent(doc.getContentType())){
				dochandler = handlers[i];
				break;
			}
		}
	}
	if(dochandler == null){
		return defaultHandler_;
	}
	return dochandler;
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:48:20 PM)
 * @return butterfly.actions.contenthandlers.interfaces.IContentHandler
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public IContentHandler getContentHandler(String type) {
	IContentHandler dochandler = (IContentHandler)contentHandlers_.get(type);
	if(dochandler == null){
		dochandler = defaultHandler_;
	}
	logger_.debug("content handler for type:"+type+" is:"+dochandler);
	return dochandler;
}
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 4:08:57 PM)
 * @return butterfly.actions.contenthandlers.interfaces.IContentHandler
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public IContentHandler getContentHandlerForFiletype(String fileextension) {
	return getContentHandler(fileextension);
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:48:20 PM)
 * @param h butterfly.actions.contenthandlers.interfaces.IContentHandler
 */
public void registerContentHandler(String fileext,IContentHandler h) {
	contentHandlers_.put(fileext,h);	
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:48:20 PM)
 * @param h butterfly.actions.contenthandlers.interfaces.IContentHandler
 */
public void removeContentHandler(IContentHandler h) {
	contentHandlers_.remove(h.getPreferredContentType());	
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:59:48 PM)
 */
public void requestActions() {
	try{
	configure(configuration_);
	}catch(Exception e){
		logger_.debug("error",e);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:59:49 PM)
 */
public void requestComponents() {
	try{
	configure(configuration_);
	}catch(Exception e){
		logger_.debug("error",e);
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:59:49 PM)
 * @param lookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(IActionLookup lookup) {actionLookup_ = lookup;}
/**
 * Insert the method's description here.
 * Creation date: (9/19/2002 11:59:49 PM)
 * @param lookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(IComponentLookup lookup) {componentLookup_ = lookup;}
}
