/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.contenthandlers;

import java.io.StringReader;
import java.util.Hashtable;

import org.apache.xerces.xni.parser.XMLInputSource;

import butterfly.actions.contenthandlers.interfaces.IUneditableContentTypeHandler;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import butterfly.xmlview.model.validation.DTDParser;


/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DTDContentHandler extends DefaultContentHandler implements IUneditableContentTypeHandler{

	/**
	 * 
	 */
	public DTDContentHandler() {
		super("text/dtd");
		// TODO Auto-generated constructor stub
	}

	
	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(java.lang.String)
	 */
	public IDocument createDocument(String src) throws Exception {
		// TODO Auto-generated method stub
		StringReader reader = new StringReader(src);
		XMLInputSource is = new XMLInputSource(null,null,null,reader,"UTF-8");
		DTDParser parser = new DTDParser();
		Hashtable structtable = parser.buildElementStructure(is);
		ValidationDocument vdoc=new ValidationDocument(IValidationDocument.TEXT_DTD_TYPE,null);
		if(structtable==null){
			
			return vdoc;}
		
		vdoc.setElementStructures((IElementStructure[])structtable.values().toArray(new IElementStructure[0]));
		return vdoc;
	}

}
