/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import org.apache.log4j.Logger;

import butterfly.xmlview.gui.PlainTextEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlEditor;
import butterfly.xmlview.io.XmlViewFileSystem;
import butterfly.xmlview.model.BasicDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IXmlDocument;

/**
 * Insert the type's description here.
 * Creation date: (11/18/2002 11:27:03 AM)
 * @author: 
 */
public class DefaultContentHandler extends AbstractContentHandler {
private static Logger logger_ = Logger.getLogger(DefaultContentHandler.class);
/**
 * DefaultContentHandler constructor comment.
 * @param type java.lang.String
 */
public DefaultContentHandler() {
	super("text/plain");
}
/**
 * DefaultContentHandler constructor comment.
 * @param type java.lang.String
 */
public DefaultContentHandler(String type) {
	super(type);
}
	/**
	 * Invoked when an action occurs.
	 */
public void actionPerformed(java.awt.event.ActionEvent e) {}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 11:27:03 AM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public IDocument createDocument(String content) throws Exception {
	BasicDocument doc = new BasicDocument();
	if(content == null){
		content="";
	}
	String name = XmlViewFileSystem.newFileName("txt");
	doc.setName(name);
	doc.setText(content);
	doc.setContentType("text/plain");
	logger_.debug("Plain Text Document Created");
	return doc;
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 11:27:03 AM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public void showDocument(butterfly.xmlview.model.interfaces.IDocument doc) {
	try{
		logger_.debug("Opening a plain text document...");
		IDocumentEditorOrganizer frame =
			(IDocumentEditorOrganizer) getLookup().getComponent(
				IDocumentEditorOrganizer.ROLE);
		String name = doc.getName();
//		if (name == null) {
//			name = doc.getName();
//		}
		logger_.debug("Making sure the document is not already open...");
		if (!frame.containsDocumentEditor(doc)) {
			IDocumentEditor editor =getEditor();
			//(IXmlEditor)getLookup().getComponent("XmlEditor");
			editor.loadDocument( doc);

			frame.addDocumentEditor(doc, (IDocumentEditor) editor);
		}
		logger_.debug("Handing focus to the document...");
		frame.showDocumentEditor(doc);
		logger_.debug("Document opened");
		
	}catch(Exception e2){
		e2.printStackTrace();
	}		
}
	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument, int)
	 */
	public void showDocument(IDocument doc, int mode) {
		// TODO Auto-generated method stub
		showDocument(doc);
	}
	public IDocumentEditor getEditor(){
		return new PlainTextEditor();
	}

}
