/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.io.File;
import java.util.Hashtable;

import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IHtmlDisplayPane;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.BasicDocument;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (9/18/2002 10:14:36 PM)
 * @author: 
 */
public class HtmlContentHandler extends AbstractContentHandler {
/**
 * HtmlContentHandler constructor comment.
 * @param type java.lang.String
 */
public HtmlContentHandler() {
	super("text/html");
}
/**
 * HtmlContentHandler constructor comment.
 * @param type java.lang.String
 */
public HtmlContentHandler(String type) {
	super(type);
}
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 3:59:57 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public IDocument createDocument(java.lang.String content) throws java.lang.Exception {
	BasicDocument doc = new BasicDocument(IDocument.TEXT_HTML_TYPE);
	if(content != null){
		doc.setText(content);
	}
	else{
		content = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"+
 
"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"+
"  <head>\n"+
"     <title>New Butterfly XHTML Document</title>\n"+
"  </head>\n"+
"  <body></body>\n"+
"</html>";
		doc.setText(content);
	}
	
	IFileSystem filesystem = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
	if(doc.getName()==null){
		File nf = filesystem.createNewFile("htm");
		doc.setName(nf.getName());
		doc.setExists(false);
		doc.setSourceFileName(nf.getAbsolutePath());
	}
	return doc;
}
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 3:59:57 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
public void showDocument(IDocument doc) {
	try{
			IDocumentEditorOrganizer docframe = (IDocumentEditorOrganizer)getLookup().getComponent(IDocumentEditorOrganizer.ROLE);
			if(!docframe.containsDocumentEditor(doc)){
				//IXmlViewBrowserPane pane = (IXmlViewBrowserPane)getComponentManager().lookup(IXmlViewBrowserPane.ROLE);
				//pane.loadDocument(doc);
			IHtmlDisplayPane editor = (IHtmlDisplayPane)getComponentManager().lookup(IHtmlDisplayPane.ROLE);
			if(editor instanceof IActionRequester){
				((IActionRequester)editor).setActionLookup(getActionLookup());
			}
  			editor.setHtml(doc.toString(),new Hashtable());
				docframe.addDocumentEditor(doc,(IDocumentEditor)editor);
			}
			docframe.showDocumentEditor(doc);
	}catch(Exception e){
		e.printStackTrace();
	}	
}
	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument, int)
	 */
	public void showDocument(IDocument doc, int mode) {
		// TODO Auto-generated method stub
		try{
		if(mode == READ_WRITE){
			IContentHandler xch = ((IContentHandlerLookup)getLookup().getComponent(IContentHandlerLookup.ROLE)).getContentHandlerForFiletype(".xml");
			IDocument xdoc = xch.createDocument(doc.toString());
			xdoc.setSourceFileName(doc.getSourceFileName());
			xdoc.setName(doc.getName());
			xch.showDocument(xdoc,READ_WRITE);
		}else{
			showDocument(doc);
		}
		}catch(Exception e){
			e.printStackTrace();
		}
	}

}
