/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.io.File;
import java.io.StringReader;
import java.util.Properties;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.xml.sax.InputSource;

import butterfly.actions.contenthandlers.interfaces.IProjectContentHandler;
import butterfly.xmlview.ButterflyProject;
import butterfly.xmlview.IProject;
import butterfly.xmlview.gui.interfaces.IProjectBrowser;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/14/2002 5:49:58 PM)
 * @author: 
 */
public class ProjectContentHandler
	extends AbstractContentHandler
	implements IProjectContentHandler {
	/**
	 * ProjectContentHandler constructor comment.
	 * @param type java.lang.String
	 */
	public ProjectContentHandler() {
		super(butterfly.xmlview.IProject.PROJECT_XML_TYPE);
	}
	/**
	 * ProjectContentHandler constructor comment.
	 * @param type java.lang.String
	 */
	public ProjectContentHandler(String type) {
		super(type);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/14/2002 5:49:58 PM)
	 * @return boolean
	 * @param contenttype java.lang.String
	 */
	public butterfly.xmlview.model.interfaces.IDocument createDocument(
		String content)
		throws Exception {

		return createDocument(content, null);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/14/2002 5:49:58 PM)
	 * @return boolean
	 * @param contenttype java.lang.String
	 */
	public void showDocument(
		butterfly.xmlview.model.interfaces.IDocument doc) {
		(
			(IProjectBrowser) getLookup().getComponent(
				IProjectBrowser.ROLE)).loadProject(
			(IProject) doc);
	}
	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(String, Properties)
	 */
	public IDocument createDocument(String content, Properties props)
		throws Exception {
		System.out.println("create project from:"+content);
		ButterflyProject p = new ButterflyProject("");
		if (content != null) {
			if (content.length() > 0) {
				StringReader r = new StringReader(content);
				InputSource src = new InputSource(r);
				Configuration conf =
					(new DefaultConfigurationBuilder()).build(src);
				p.configure(conf);
			}
		}
		else if(props != null){
			String name = props.getProperty("Name");
			System.out.println("name set to:"+name);
			p.setProjectName(name);
		}
		if(content == null){
			
		}
		
		return p;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument, int)
	 */
	public void showDocument(IDocument doc, int mode) {
		// TODO Auto-generated method stub
		showDocument(doc);
	}

	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#saveDocument(String, IDocument)
	 */
	public void saveDocument(String savename, IDocument doc) throws Exception {
		String origname = doc.getName();
		File file = new File(savename);
		if (!savename.equals(doc.getSourceFileName())) {
			
			doc.setSourceFileName(savename);
		}
		super.saveDocument(savename, doc);
		
	}

}
