/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.io.File;
import java.util.Properties;

//import butterfly.Profiler;
import butterfly.actions.contenthandlers.interfaces.IContentType;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXFormEditor;
import butterfly.xmlview.gui.interfaces.IXmlEditor;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IXmlDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class XFormContentHandler extends XmlContentHandler {

	public static final String XFORM_CONTENT_TYPE = "text/xform";
	/**
	 * Constructor for XFormContentHandler.
	 */
	public XFormContentHandler() {
		super(XFORM_CONTENT_TYPE);
	}

	/**
	 * Constructor for XFormContentHandler.
	 * @param type
	 */
	public XFormContentHandler(String type) {
		super(type);
	}

	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(IDocument)
	 */
	public void showDocument(IDocument doc) {
		try {
			//Profiler.start("XmlContentHandler.showDocument()");
			IDocumentEditorOrganizer frame =
				(IDocumentEditorOrganizer) getLookup().getComponent(
					IDocumentEditorOrganizer.ROLE);
			String name = doc.getName();
//			if (name == null) {
//				name = doc.getName();
//			}
			if (!frame.containsDocumentEditor(doc)) {
				IXmlEditor editor =
					(IXmlEditor) getComponentManager().lookup(IXmlEditor.ROLE);
				//(IXmlEditor)getLookup().getComponent("XmlEditor");
				editor.loadXmlModel((IXmlDocument) doc);

				frame.addDocumentEditor(doc, (IDocumentEditor) editor);
			}
			frame.showDocumentEditor(doc);
			//Profiler.end("XmlContentHandler.showDocument()");
		} catch (Exception e2) {
			e2.printStackTrace();
			//Profiler.end("XmlContentHandler.showDocument()");
		}
	}

	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#getPreferredContentType()
	 */
	public IContentType getPreferredContentType() {
		return super.getPreferredContentType();
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(java.lang.String, java.util.Properties)
	 */
	public IDocument createDocument(String contents, Properties params)
		throws Exception {
		// TODO Auto-generated method stub
		if(contents == null ){
			contents = "<?xml version=\"1.0\"?>\n"+
"<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n"+
"  <head>\n"+
"    <xforms:model id=\"form_id\">\n"+
"      <xforms:submission id=\"\" method=\"post\" action=\"\"/>\n"+
"      <xforms:instance id=\"\"></xforms:instance>\n"+
"    </xforms:model>\n"+
"  </head>\n"+
"  <body></body>\n"+
"</html>";
		}
		IDocument doc = super.createDocument(contents, params);
		((XmlDocument)doc).setContentType("text/xform");
		IFileSystem filesystem = (IFileSystem)getLookup().getComponent(IFileSystem.ROLE);
		if(doc.getName()==null){
			File nf = filesystem.createNewFile("xform");
			doc.setName(nf.getName());
			doc.setExists(false);
			doc.setSourceFileName(nf.getAbsolutePath());
		}
		return doc;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument, int)
	 */
	public void showDocument(IDocument doc, int mode) {
		// TODO Auto-generated method stub
		showDocument(doc);
	}

}
