/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.io.File;
import java.net.URL;
import java.util.Properties;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.IXmlEditor;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Comment;
import butterfly.xmlview.model.DocumentDeclaration;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.validation.CompoundValidationDocument;
import butterfly.xmlview.model.validation.GenericValidationDocument;
import butterfly.xmlview.model.validation.HtmlValidationDocument;
import butterfly.xmlview.model.validation.SchemaParser;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IGrammarFactory;
/**
 * Insert the type's description here.
 * Creation date: (9/18/2002 6:06:34 PM)
 * @author: 
 */
public class XmlContentHandler extends AbstractContentHandler {
	public static final String ROOT_ELEMENT_KEY = "Root Element";
	public static final String CHARACTER_ENCODING_KEY = "Character Encoding";
	public static final String SCHEMA_KEY = "Schema/DTD File";
	private Comment editorComment_= new Comment("Edited with the Butterfly XML Editor (http://www.butterflyxml.org)"){
		public String toString(){
			return "\n"+super.toString();
		}
	};
	/**
	 * XmlContentHandler constructor comment.
	 * @param type java.lang.String
	 */
	public XmlContentHandler() {
		super(butterfly.xmlview.model.XmlDocument.TEXT_XML_TYPE);
	}

	public XmlContentHandler(String type) {
		super(type);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/20/2002 3:46:55 PM)
	 * @return boolean
	 * @param contenttype java.lang.String
	 */
	public IDocument createDocument(String contents) throws Exception {
		return createDocument(contents, null);
	}

	public IDocument createDocument(String contents, Properties params)
		throws Exception {
		if(contents != null){
		//	Profiler.start("XmlContentHandler.createDocument(content!=null)");
			XmlDocument doc = new XmlDocument(contents);	
			doc.setGrammarFactory((IGrammarFactory)getLookup().getComponent(IGrammarFactory.ROLE));
			GenericValidationDocument gvd = new GenericValidationDocument(doc);
			((CompoundValidationDocument)doc.getValidationDocument()).setDefaultValidationDocument(gvd);
			if(((CompoundValidationDocument)doc.getValidationDocument()).getValidationDocument(null)==null){
				doc.addValidationDocument(null,new HtmlValidationDocument());
			}
			
			
			//	Profiler.end("XmlContentHandler.createDocument(content!=null)");
			return doc;
		}
		XmlDocument doc = null;
		if (params != null && contents == null) {
			String schema = params.getProperty(SCHEMA_KEY);
			String root = params.getProperty(ROOT_ELEMENT_KEY);
			if (schema != null && root != null) {
				if (schema.trim().length() > 1) {
					if(!schema.startsWith("/") && !schema.startsWith("file://")){
						schema = "/"+schema;
					}
					if (!schema.startsWith("file://")) {
						schema = "file://" + schema;
					}
					SchemaParser parser = new SchemaParser();
					contents = parser.createStub(schema.toString(), root);
					if (contents != null) {
						if (contents.trim().length() < 1) {
							contents = null;
						}
						else{
							if (!schema.startsWith("file:///")) {
						schema = "file:///" + schema;
					}
				//	System.out.println("setting the schema");
					String type = "text/xsd";
					if (schema.trim().endsWith("dtd")) {
						type = "text/dtd";
					}
					doc = new XmlDocument(contents);
					doc.setGrammarFactory((IGrammarFactory)getLookup().getComponent(IGrammarFactory.ROLE));
					URL url = new URL(schema);
					ValidationDocument valid =
						new ValidationDocument(type, null);
					valid.setURL(url);
					doc.setValidationDocument(valid);
					Element roote = (Element)((DocumentRoot)doc.getRoot()).firstElement();
					if (roote != null) {
						Attribute attr = new Attribute("xmlns:xs");
						attr.setData(
							"http://www.w3.org/2001/XMLSchema-instance");
						Attribute attr2 =
							new Attribute("xs:noNamespaceSchemaLocation");
						attr2.setData(schema);

						roote.addAttribute(attr);
						roote.addAttribute(attr2);
					//	System.out.println("schema set on root");
					}
								
						}
					}
					
				}
			}
		}

		if(doc == null){
		if (contents != null) {
			try {
				doc = new XmlDocument(contents);
			} catch (Exception e) {
				doc = new XmlDocument();
			}
		} else {
			doc = new XmlDocument();
		}
		doc.setGrammarFactory((IGrammarFactory)getLookup().getComponent(IGrammarFactory.ROLE));
		}

		if (params != null) {
		//	System.out.println("createDocument() params:");
			params.list(System.out);
			String root = params.getProperty(ROOT_ELEMENT_KEY);
			String schema = params.getProperty(SCHEMA_KEY);
			if(schema != null){
				if(schema.trim().length() < 1){
					schema = null;	
				}	
			}
			String code = params.getProperty(CHARACTER_ENCODING_KEY);
			//System.out.println("root:" + root);

			Element roote = null;
			if (root != null && schema == null) {
				if (root.trim().length() > 0) {
					Element el = new Element(root);
					el.setEndTagLength(0);
					el.setEndTagStart(0);

					roote = el;
				//	System.out.println("root set");
					if (roote != null) {
				doc.addChild(
					doc.getRoot(),
					roote,
					doc.getRoot().childCount(),
					true);
			}
				}
			}
//			if (schema != null) {
//				if (schema.trim().length() > 0) {
//					
//				}
//			}

			

		} 
		//doc.tidy(((DocumentRoot)doc.getRoot()).firstElement());
		GenericValidationDocument gvd = new GenericValidationDocument(doc);
		((CompoundValidationDocument)doc.getValidationDocument()).setDefaultValidationDocument(gvd);
		if(((CompoundValidationDocument)doc.getValidationDocument()).getValidationDocument(null)==null){
			doc.addValidationDocument(null,new HtmlValidationDocument());
		}
		
		int where = 0;
		if(doc.getRoot().childCount() > 0){
			if(doc.getRoot().childAt(0) instanceof DocumentDeclaration){
				where++;
			}
		}
		doc.addChild(doc.getRoot(),editorComment_,where,true);
		return doc;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/18/2002 11:25:47 AM)
	 * @param name java.lang.String
	 * @param doc butterfly.xmlview.model.interfaces.IDocument
	 * @exception java.lang.Exception The exception description.
	 */
	public void saveDocument(String savename, IDocument doc)
		throws java.lang.Exception {
		String origname = doc.getName();
		File file = new File(savename);
		if (!savename.equals(doc.getSourceFileName())) {
			IDocumentEditorOrganizer docframe =
				(IDocumentEditorOrganizer) getLookup().getComponent(
					IDocumentEditorOrganizer.ROLE);

			if (docframe.containsDocumentEditor(doc)) {
				docframe.changeDocumentEditorName(doc, file.getName());
			}
			doc.setSourceFileName(savename);
		}
		super.saveDocument(savename, doc);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/20/2002 3:46:55 PM)
	 * @return boolean
	 * @param contenttype java.lang.String
	 */
	public void showDocument(IDocument doc) {
		try {
			//Profiler.start("XmlContentHandler.showDocument()");
			IDocumentEditorOrganizer frame =
				(IDocumentEditorOrganizer) getLookup().getComponent(
					IDocumentEditorOrganizer.ROLE);
			String name = doc.getName();
//			if (name == null) {
//				name = doc.getName();
//			}
			if (!frame.containsDocumentEditor(doc)) {
				IXmlEditor editor =getEditor();
				//(IXmlEditor)getLookup().getComponent("XmlEditor");
				editor.loadXmlModel((IXmlDocument) doc);

				frame.addDocumentEditor(doc, (IDocumentEditor) editor);
			}
			frame.showDocumentEditor(doc);
			//Profiler.end("XmlContentHandler.showDocument()");
		} catch (Exception e2) {
			e2.printStackTrace();
			//Profiler.end("XmlContentHandler.showDocument()");
		}
	}
	
	public IXmlEditor getEditor() throws Exception{
		return (IXmlEditor) getComponentManager().lookup(IXmlEditor.ROLE);
	}
	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument, int)
	 */
	public void showDocument(IDocument doc, int mode) {
		// TODO Auto-generated method stub
		showDocument(doc);
	}

}
