/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers;

import java.util.Properties;

import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class XsdContentHandler extends XmlContentHandler {

	/**
	 * Constructor for XsdContentHandler.
	 */
	public XsdContentHandler() {
		super("text/xml-schema");
	}

	/**
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(String, Properties)
	 */
	public IDocument createDocument(String content, Properties props)
		throws Exception {
		if(content == null){
			content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n  <xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\n    <xs:element name=\"root\"></xs:element>\n</xs:schema>";	
		}
		return super.createDocument(content, props);
	}



}
