/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.contenthandlers;

import java.awt.event.ActionEvent;
import java.util.Properties;

import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

import butterfly.xmlview.gui.NodeMenuFactory;
import butterfly.xmlview.gui.TabbedXmlEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.INodeMenuBuilder;
import butterfly.xmlview.gui.interfaces.IXmlEditor;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.xslt.Breakpoint;
import butterfly.xmlview.xslt.BreakpointMarker;
import butterfly.xmlview.xslt.XsltDebugger;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class XslContentHandler extends XmlContentHandler implements INodeMenuBuilder{
	class AddBreakpointAction extends AbstractAction{
		public IElement element;
		
		public void actionPerformed(ActionEvent ae){
			BreakpointMarker m = new BreakpointMarker(new Breakpoint(0));
			element.addMarker(m);
		}
		
	}
	class RemoveBreakpointAction extends AbstractAction{
		public IElement element;
		
		public void actionPerformed(ActionEvent ae){
			IMarker[] breaks = element.getMarkersWithID(BreakpointMarker.ID);
			for(int i = 0; i < breaks.length; i++){
				element.removeMarker(breaks[i]);
			}
		}
		
	}
	private AddBreakpointAction addBreak_=new AddBreakpointAction();
	private RemoveBreakpointAction removeBreak_=new RemoveBreakpointAction();
	/**
	 * 
	 */
	public XslContentHandler() {
		super("text/xsl");
		NodeMenuFactory.registerMenuBuiderForContentType(this,"text/xsl");
		// TODO Auto-generated constructor stub
	}

	

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#createDocument(java.lang.String, java.util.Properties)
	 */
	public IDocument createDocument(String contents, Properties params)
		throws Exception {
		if(contents == null){
			contents = "<?xml version=\"1.0\"?>\n\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n"+
			"  <xsl:template match=\"/\">\n"+
			"    <xsl:apply-templates/>\n"+
			"  </xsl:template>\n</xsl:stylesheet>";
		}
		
		// TODO Auto-generated method stub
		XmlDocument doc =  (XmlDocument)super.createDocument(contents, params);
		doc.setContentType("text/xsl");
		return doc;
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.XmlContentHandler#getEditor()
	 */
	public IXmlEditor getEditor() throws Exception {
		// TODO Auto-generated method stub
		return (IXmlEditor)getComponentManager().lookup("butterfly.xmlview.gui.XslEditor");
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.contenthandlers.interfaces.IContentHandler#showDocument(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public void showDocument(XmlDocument xsldoc,XmlDocument input) {
		try {
			//Profiler.start("XmlContentHandler.showDocument()");
			IDocumentEditorOrganizer frame =
			(IDocumentEditorOrganizer) getLookup().getComponent(
					IDocumentEditorOrganizer.ROLE);
			String name = xsldoc.getName();
//			if (name == null) {
//				name = doc.getName();
//			}
			System.out.println("Input for debugging:"+input);
			if (!frame.containsDocumentEditor(xsldoc)) {
				IXmlEditor editor =getEditor();
				//(IXmlEditor)getLookup().getComponent("XmlEditor");
				editor.loadXmlModel( xsldoc);
				XsltDebugger debugger = (XsltDebugger)((TabbedXmlEditor)editor).getRenderer("Debug");
				debugger.setInput(input);
				frame.addDocumentEditor(xsldoc, (IDocumentEditor) editor);
			}
			else{
				XsltDebugger debugger = (XsltDebugger)((TabbedXmlEditor)frame.getDocumentEditor(xsldoc)).getRenderer("Debug");
				debugger.setInput(input);
			}
			frame.showDocumentEditor(xsldoc);
			((TabbedXmlEditor)frame.getDocumentEditor(xsldoc)).switchRenderer("Debug");
			//Profiler.end("XmlContentHandler.showDocument()");
		} catch (Exception e2) {
			e2.printStackTrace();
			//Profiler.end("XmlContentHandler.showDocument()");
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.INodeMenuBuilder#buildEditingMenuForNode(javax.swing.JPopupMenu, butterfly.xmlview.model.interfaces.INode)
	 */
	public void buildEditingMenuForNode(JPopupMenu m, INode node) {
		// TODO Auto-generated method stub
		if(node instanceof IElement){
			IMarker[] breaks = node.getMarkersWithID(BreakpointMarker.ID);
			m.addSeparator();
			if(breaks == null || breaks.length < 1){
				addBreak_.element=(IElement)node;
				m.add(addBreak_).setText("Add Breakpoint");
			}
			else{
				removeBreak_.element=(IElement)node;
				m.add(removeBreak_).setText("Remove Breakpoint");
			}
		}
	}

}
