/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions.contenthandlers.interfaces;

import java.util.Properties;

import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.components.interfaces.IComponent;
/**
 * Insert the type's description here.
 * Creation date: (9/18/2002 4:39:30 PM)
 * @author: 
 */
public interface IContentHandler extends IComponent{
	
public static final int READ_ONLY=1;
public static final int READ_WRITE=2;
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
IParameterValidationError[] validateParams(Properties props);
boolean canHandleContent(IContentType contenttype);
boolean canHandleContent(String contenttype);
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
IDocument createDocument(String content)throws Exception;
IDocument createDocument(String content,Properties props)throws Exception;
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
IContentType getPreferredContentType();
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
IDocument loadDocument(String filename)throws Exception;
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
void saveDocument(String name,IDocument doc) throws Exception;
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 6:01:38 PM)
 * @return boolean
 * @param contenttype java.lang.String
 */
void showDocument(IDocument doc);
void showDocument(IDocument doc, int mode);
}
