/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.document;

import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.TagInfo;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IValidatedDocument;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class AddElementAction extends AddNodeAction {
	private String elementName_ = null;
	private String elementNamespace_=null;
	/* (non-Javadoc)
	 * @see butterfly.actions.document.AddNodeAction#getNodeToAdd()
	 */
	public INode getNodeToAdd() {
		if(super.getNodeToAdd()==null){
			if(getElementName()==null){
			IXmlViewInformer informer =
			(IXmlViewInformer) getLookup().getComponent(
					IXmlViewInformer.ROLE);
			
			elementName_ =
			informer.displayQuery("Enter the name for the new Element");
			}
			TagInfo info = new TagInfo(ITagInfo.ELEMENT_TAG);
			info.setName(elementName_);
			info.setNamespace(elementNamespace_);
			setNodeToAdd(
			((IValidatedDocument) getDocument()).createNode(
					info)
			);
			((IElement)getNodeToAdd()).setEndTagStart(0);
		}
		return super.getNodeToAdd();
	}
	
	public String getElementName(){
		return elementName_;
	}
	public void setElementName(String name){
		elementName_=name;
	}
	public void setElementNamespace(String ns){
		elementNamespace_=ns;
	}
	public String getElementNamespace(){
		return elementNamespace_;
	}

	/**
	 * @param setlookups
	 */
	public AddElementAction(String namespace,String name) {
		super(true);
		elementName_=name;
		elementNamespace_=namespace;
		// TODO Auto-generated constructor stub
	}

}
