/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.document;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class AddNodeAction extends DocumentNodeAction {
	private INode toAdd_ = null;
	private int where_ = -1;
	private boolean updateSource_ = true;
	private static final ImageIcon appendc_ =new ImageIcon("icons/stock_append-child-16.png");
	
	public AddNodeAction(){
		putValue(AbstractAction.SMALL_ICON,appendc_);
	}
	public AddNodeAction(boolean setlookups){
		this();
		ButterflyApplication.setLookups(this);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		INode parent = getNode();
		INode toAdd = getNodeToAdd();
		int where = getAddIndex();
		if(where < 0){
			where = getNode().childCount();
		}
		IDocument doc = getDocument();
		boolean updatesrc = willUpdateSource();
	
		doc.addChild(parent,toAdd,where,updatesrc);
	}
	
	public IDocument getDocument(){
		if(getNode() != null){
			return getNode().getDocument();
		}
		return null;
	}
	
	public void setNodeToAdd(INode node){
		toAdd_ = node;
	}

	public INode getNodeToAdd(){
		return toAdd_;
	}
	
	public void setAddIndex(int index){
		where_=index;
	}
	public int getAddIndex(){
		return where_;
	}
	public boolean willUpdateSource(){
		return updateSource_;
	}
	public void setUpdateSource(boolean up){
		updateSource_ =up;
	}
	
}
