/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.document;

import java.awt.event.ActionEvent;
import java.io.File;

import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IElement;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class AppendSchemaAction extends DocumentNodeAction {
	private String namespaceToBind_;
	private boolean promptForNs_=false;
	
	public AppendSchemaAction(){
		putValue(NAME,"Append Schema");
		//putValue(this.ACCELERATOR_KEY,KeyStroke.getKeyStroke(new Character('n'),KeyEvent.CTRL_MASK));
	}
	
	public void setPromptForNamespace(boolean p){
		promptForNs_=p;
	}
	public void setNamespaceToBind(String ns){
		namespaceToBind_=ns;
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(getLookup()==null){
			ButterflyApplication.setLookups(this);
		}
		
		if(namespaceToBind_==null && promptForNs_){
			IXmlViewInformer informer =
			(IXmlViewInformer) getLookup().getComponent(
					IXmlViewInformer.ROLE);
			
			namespaceToBind_ =
			informer.displayQuery("What namespace would you like to add a schema for?");
			if(namespaceToBind_.trim().length()<1){
				return;
			}
		
		}
		
		
		
		IFileChooseAction fc = (IFileChooseAction)getActionLookup().getAction(IFileChooseAction.ROLE);
		
		fc.actionPerformed(null);
		File file = fc.getSelectedFile();
		
		if(file != null){		
			String uri = file.getAbsoluteFile().toURI().toString();
			IElement el = (IElement)getNode();
			XmlDocument doc = (XmlDocument)el.getDocument();
			
			
			
			String prefix = doc.getPrefixForNamespace(XmlDocument.XML_SCHEMA_NAMESPACE);
			
			if(prefix == null){
				prefix = "xsi";
				NamespacePrefixMapping npm = new NamespacePrefixMapping(prefix,XmlDocument.XML_SCHEMA_NAMESPACE);
				el.addAttribute(npm);
			}
			
			Attribute si = null;
			if(namespaceToBind_==null){
				si = new Attribute(prefix+":noNamespaceSchemaLocation",uri);
				el.addAttribute(si);
			}
			else{
				si=(Attribute)el.getAttribute(XmlDocument.XML_SCHEMA_NAMESPACE,XmlDocument.SCHEMA_LOCATION_ATTRIBUTE);
				if(si == null){
					si = new Attribute(prefix+":schemaLocation",namespaceToBind_+" "+uri);
					el.addAttribute(si);
				}
				else{
					si.setData(si.getData()+"\n "+namespaceToBind_+" "+uri);
				}
			}
			
			doc.updateNode(el,true);
		}
		
	}

}
