/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.actions.document;

import java.awt.event.ActionEvent;

import butterfly.actions.DocumentAction;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceElement;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class IndentNodeAction extends DocumentAction {
	private int index_;
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent ae) {
		try{
			IDocument doc = getDocument();
			String src = doc.toString();
			
			int index = getIndex();
			int linestart = src.lastIndexOf("\n",index-1);
			int curr = index-linestart-1;
			if(linestart < 0){
				linestart=0;
			}
			String tab="  ";
			
			if(src.substring(linestart,index).trim().length()==0 &&
			   (doc instanceof IModelToSourceMapping)){				
	
				int lineend = index;
				INode parent = getParent();
				boolean pushparent = false;
				if(parent instanceof ISourceElement){
					if(pushingParentEndTag(linestart,((ISourceElement)parent))){
						pushparent = true;
						lineend=parent.getStart()-1;
						linestart = src.lastIndexOf("\n",lineend);
					}
				}
				if(!pushparent){
					
				if(parent.childCount()>0){
					lineend = parent.childAt(parent.childCount()-1).getStart()-1;
					linestart = src.lastIndexOf("\n",lineend);
				}
				else{
					lineend=parent.getStart()+2;
					linestart = src.lastIndexOf("\n",lineend);
				}
				if(linestart < 0){
					linestart = 0;
				}
				}
				String bigtab = "                                                                                                                                                            ";
				if(curr < (lineend - linestart)){
					tab = bigtab.substring(0,lineend-linestart-curr);
				}
				
			}
			
			doc.insertString(index,tab);
		}catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
	}

	private boolean pushingParentEndTag(int newline, ISourceElement parent){
		if(newline == getDocument().toString().lastIndexOf("\n",parent.getEndTagStart()+1)){
			return true;
		}
		return false;
	}
	
	private INode getParent(){
		int index = getIndex();
		IDocument doc = getDocument();
		
		INode before = ((IModelToSourceMapping)doc).nodeBefore(index);
		INode parent = null;
		if(before instanceof ISourceElement){
			if(((ISourceElement)before).getEndTagStart() >= index){
				parent = before;
			}
			else{
				parent = before.getParent();
			}
		}else{
			parent = before.getParent();
		}
		return parent;
	}
	
	/**
	 * @return Returns the index_.
	 */
	public int getIndex() {
		return index_;
	}

	/**
	 * @param index_ The index_ to set.
	 */
	public void setIndex(int index) {
		this.index_ = index;
	}

}
