/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.protocols.butterfly;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ButterflyConnection extends URLConnection implements IActionRequester{
	private IActionLookup actionLookup_;
	private IDocument document_;
	/**
	 * Constructor for ButterflyConnection.
	 * @param url
	 */
	public ButterflyConnection(URL url) {
		super(url);
	}

	/**
	 * @see java.net.URLConnection#connect()
	 */
	public void connect() throws IOException {
		if(actionLookup_ == null){
			ButterflyApplication.setLookups(this);	
			getDocument();
		}
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#requestActions()
	 */
	public void requestActions() {
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#setActionLookup(IActionLookup)
	 */
	public void setActionLookup(IActionLookup lookup) {
		actionLookup_=lookup;
	}

	/**
	 * @see java.net.URLConnection#getContentType()
	 */
	public String getContentType() {
		return getDocument().getContentType();
	}

	/**
	 * @see java.net.URLConnection#getInputStream()
	 */
	public InputStream getInputStream() throws IOException {
		IDocument doc = getDocument();
		String src = doc.toString();
		ByteArrayInputStream bis = new ByteArrayInputStream(src.getBytes());
		return bis;
	}
	
	public IDocument getDocument(){
		if(document_ == null){
		URL url = getURL();
		String path = url.getPath();
		IFileOpenAction fopen = (IFileOpenAction)actionLookup_.getAction(IFileOpenAction.ROLE);
		fopen.setFile(new File(path));
		fopen.setAccessHistoryEnabled(false);
		fopen.setShowFile(false);
		
		fopen.actionPerformed(null);
		document_= fopen.getDocument();
		}
		return document_;
	}
	
	

}
