/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import java.util.Hashtable;
/**
 * Insert the type's description here.
 * Creation date: (12/2/2002 11:37:15 AM)
 * @author: 
 */
public class DocumentEditorStateEvent extends StateEvent {
	public static final String ID = "document-editor-event";
	public static int NODE_SELECTION_CHANGED = 1;
	public static int NODES_REMOVED = 2;
	public static int NODES_ADDED = 3;
	public static int NODES_CHANGED = 4;

	public static String CHANGED_NODES_KEY = "changed-nodes";
	public static String PARENT_KEY = "parent";
	public static String TYPE_KEY = "type";

	private INode parent_;
	private INode[] changedNodes_;
	private int type_;
/**
 * DocumentEditorStateEvent constructor comment.
 * @param id java.lang.String
 * @param source java.lang.Object
 */
public DocumentEditorStateEvent(IDocumentEditor source) {
	super(ID, source);
	
}
/**
 * DocumentEditorStateEvent constructor comment.
 * @param id java.lang.String
 * @param source java.lang.Object
 */
public DocumentEditorStateEvent(IDocumentEditor source,INode parent, INode[] changed, int type) {
	super(ID, source);
	parent_ = parent;
	changedNodes_ = changed;
	type_ = type;
	
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:40:46 AM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public INode[] getChangedNodes() {
	return changedNodes_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:49:25 AM)
 * @return java.util.Hashtable
 */
public Hashtable getEventData() {
	Hashtable table = super.getEventData();
	if(table == null){
		table = new Hashtable(3);
	}
	if(parent_ != null){
		table.put(PARENT_KEY,parent_);
	}
	if(changedNodes_ != null){
		table.put(CHANGED_NODES_KEY,changedNodes_);
	}
	if(type_ > 0){
		table.put(TYPE_KEY,new Integer(type_));
	}
	super.setEventData(table);
	return table;
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:40:52 AM)
 * @return butterfly.xmlview.model.interfaces.INode
 */
public INode getParent() {
	return parent_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:41:34 AM)
 * @return int
 */
public int getType() {
	return type_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:40:46 AM)
 * @param newChangedNodes butterfly.xmlview.model.interfaces.INode[]
 */
public void setChangedNodes(INode[] newChangedNodes) {
	changedNodes_ = newChangedNodes;
	
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:40:52 AM)
 * @param newParent butterfly.xmlview.model.interfaces.INode
 */
public void setParent(butterfly.xmlview.model.interfaces.INode newParent) {
	parent_ = newParent;
	
	
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 11:41:34 AM)
 * @param newType int
 */
public void setType(int newType) {
	type_ = newType;
	
}
}
