/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (10/13/2002 10:08:27 PM)
 * @author: 
 */
public class SourceElementSelectionEvent extends StateEvent {
	private String elementNamespace_;
	private String elementName_;
	private String xpath_;
	private IXmlDocument xmlModel_;

	public static final String ID = "element-selection";
/**
 * SourceElementSelectionEvent constructor comment.
 * @param id java.lang.String
 * @param source java.lang.Object
 */
public SourceElementSelectionEvent(Object source) {
	super(ID, source);
}
/**
 * SourceElementSelectionEvent constructor comment.
 * @param id java.lang.String
 * @param source java.lang.Object
 */
public SourceElementSelectionEvent(String id, Object source) {
	super(id, source);
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @return java.lang.String
 */
public java.lang.String getElementName() {
	return elementName_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @return java.lang.String
 */
public java.lang.String getElementNamespace() {
	return elementNamespace_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/16/2002 10:51:51 AM)
 * @return butterfly.xmlview.model.interfaces.IXmlDocument
 */
public butterfly.xmlview.model.interfaces.IXmlDocument getXmlModel() {
	return xmlModel_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @return java.lang.String
 */
public java.lang.String getXpath() {
	return xpath_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @param newElementName_ java.lang.String
 */
public void setElementName(java.lang.String newElementName_) {
	elementName_ = newElementName_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @param newElementNamespace_ java.lang.String
 */
public void setElementNamespace(java.lang.String newElementNamespace_) {
	elementNamespace_ = newElementNamespace_;
}
/**
 * Insert the method's description here.
 * Creation date: (10/16/2002 10:51:51 AM)
 * @param newXmlModel butterfly.xmlview.model.interfaces.IXmlDocument
 */
public void setXmlModel(butterfly.xmlview.model.interfaces.IXmlDocument newXmlModel) {
	xmlModel_ = newXmlModel;
}
/**
 * Insert the method's description here.
 * Creation date: (10/13/2002 10:09:37 PM)
 * @param newXpath_ java.lang.String
 */
public void setXpath(java.lang.String newXpath_) {
	xpath_ = newXpath_;
}
}
