/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import butterfly.statemachine.interfaces.*;
import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.apache.log4j.Logger;
/**
 * Insert the type's description here.
 * Creation date: (9/16/2002 11:15:01 AM)
 * @author: 
 */
public class State implements IState , Configurable, IActionRequester{
	private String name_;
	private Hashtable eventMap_;
	private Hashtable eventActionMap_;
	private IActionLookup actionLookup_;
	private Configuration configuration_;

	private static Logger logger_ = Logger.getLogger(State.class);

	public static final String STATE_ACTION = "action";
	public static final String STATE_NAME = "name";
	public static final String EVENT_MAPPINGS = "event-map";
	public static final String NEXT_STATE = "next-state";
	public static final String EVENT = "event";
	public static final String ACTION_ROLE = "action-role";

	private IButterflyAction action_;
	
/**
 * State constructor comment.
 */
public State() {
	super();
	eventMap_ = new Hashtable();
	eventActionMap_ = new Hashtable();
}
/**
 * State constructor comment.
 */
public State(String name) {
	super();
	name_ = name;
	eventMap_ = new Hashtable();
	eventActionMap_ = new Hashtable();
}
/**
 * Insert the method's description here.
 * Creation date: (9/17/2002 8:56:04 AM)
 * @param conf org.apache.avalon.framework.configuration.Configuration
 */
private void buildEventMap(Configuration conf) {
	Configuration[] eventmaps = conf.getChildren();
	String event = null;
	String next = null;
	String actionrole = null;
	for(int i = 0; i < eventmaps.length; i++){
		try{
		event = eventmaps[i].getAttribute(EVENT);
		next = eventmaps[i].getAttribute(NEXT_STATE);
		actionrole = eventmaps[i].getAttribute(ACTION_ROLE);

		IButterflyAction action = (IButterflyAction)actionLookup_.getAction(actionrole);
	
		eventMap_.put(event,next);
		if(action != null){
			eventActionMap_.put(event,action);
		}
		logger_.debug("mapped event:"+event+" to "+next);
		}catch(Exception e){
			logger_.debug("could not map "+event+" to "+next);
		}
	}	
}
/**
 * configure method comment.
 */
public void configure(Configuration conf) throws ConfigurationException {
	if(configuration_ == null){
		configuration_ = conf;
		return;
	}
	name_ = conf.getAttribute(STATE_NAME);
	//String role = conf.getAttribute(STATE_ACTION);
	//if(!role.equalsIgnoreCase("none")){
		//action_ = actionLookup_.getAction(role);
	//}
	Configuration mappings = conf.getChild(EVENT_MAPPINGS);
	buildEventMap(mappings);
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:15:01 AM)
 * @return java.lang.String
 */
public String getName() {
	return name_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:15:01 AM)
 * @param event butterfly.statemachine.IStateEvent
 */
public String handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	
	String next = (String)eventMap_.get(event.getID());
	logger_.debug("handleEvent>>NextState: "+next);
	IButterflyAction act = (IButterflyAction)eventActionMap_.get(event.getID());
	logger_.debug("handleEvent>>Action: "+act);
	if(act != null){
		if(act instanceof IStateAction){
			Hashtable eventdat = event.getEventData();
			((IStateAction)act).setStateEventData(eventdat);
		}
		act.actionPerformed(null);
	}
	if(next != null){
		return next;
	}
	return getName();	
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:15:01 AM)
 * @param eventid java.lang.String
 * @param stateid java.lang.String
 */
public void mapEventToState(String eventid, String stateid) {
	eventMap_.put(eventid,stateid);	
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:15:01 AM)
 * @param eventid java.lang.String
 * @param stateid java.lang.String
 */
public void mapEventToState(String eventid, String stateid, IButterflyAction act) {
	eventMap_.put(eventid,stateid);
	eventActionMap_.put(eventid,act);
}
/**
 * Insert the method's description here.
 * Creation date: (9/17/2002 8:37:29 AM)
 */
public void requestActions() {
	try{
		configure(configuration_);
	}catch(Exception e){
		logger_.debug("State:"+getName()+" was unable to complete its action requests.",e);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/17/2002 8:37:29 AM)
 * @param lookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup lookup) {
	actionLookup_ = lookup;	
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:18:35 AM)
 */
public void stateEntered() {
	//if(action_ != null){
		//action_.actionPerformed(null);
	//}
}
}
