/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import java.util.Hashtable;
/**
 * Insert the type's description here.
 * Creation date: (9/16/2002 11:14:49 AM)
 * @author: 
 */
public class StateEvent implements butterfly.statemachine.interfaces.IStateEvent {
	private String id_;
	private Object source_;
	private Hashtable eventData_;
	public static final String SOURCE_KEY = "state-event-source";
	public static final String ID_KEY = "state-event-id";
/**
 * StateEvent constructor comment.
 */
public StateEvent(String id, Object source) {
	super();
	id_ = id;
	source_ = source;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:42:19 AM)
 * @return java.util.Hashtable
 */
public java.util.Hashtable getEventData() {
	if(eventData_ == null){
		eventData_ = new Hashtable(2);
	}
	if(getSource() != null){
		eventData_.put(SOURCE_KEY,getSource());
		eventData_.put(ID_KEY,id_);	
	}
	return eventData_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:49 AM)
 * @return java.lang.String
 */
public String getID() {
	return id_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:49 AM)
 * @return java.lang.Object
 */
public Object getSource() {
	return source_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:42:19 AM)
 * @param newEventData java.util.Hashtable
 */
public void setEventData(java.util.Hashtable newEventData) {
	eventData_ = newEventData;
}

public void addEventData(Object key,Object value){
	if(eventData_ == null){
		eventData_ = new Hashtable(1);
	}
	eventData_.put(key,value);	
	}	

	/**
	 * Sets the source.
	 * @param source The source to set
	 */
	public void setSource(Object source) {
		source_ = source;
	}

}
