/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import butterfly.statemachine.interfaces.IStateEventListener;
import java.util.Vector;
/**
 * Insert the type's description here.
 * Creation date: (10/14/2002 6:54:34 PM)
 * @author: 
 */
public class StateListenerManager {
	private Vector listeners_ = new Vector(1);
/**
 * StateListenerManager constructor comment.
 */
public StateListenerManager() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (10/14/2002 6:55:17 PM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void addListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listeners_.add(l);	
}
/**
 * Insert the method's description here.
 * Creation date: (10/14/2002 6:56:40 PM)
 * @param e butterfly.statemachine.interfaces.IStateEvent
 */
public void fireEvent(butterfly.statemachine.interfaces.IStateEvent e) {
	for(int i = 0; i < listeners_.size(); i++){
		((IStateEventListener)listeners_.elementAt(i)).handleEvent(e);
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (10/14/2002 6:55:17 PM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void removeListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listeners_.remove(l);	
}
}
