/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.statemachine;

import butterfly.statemachine.interfaces.*;
import butterfly.components.interfaces.IComponent;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IActionLookup;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.apache.log4j.Logger;
/**
 * Insert the type's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @author: 
 */
public class StateMachine implements butterfly.statemachine.interfaces.IStateMachine,Configurable,IActionRequester,IComponent{
	private Hashtable states_;
	private IState currentState_;
	private IState initialState_;
	private Configuration configuration_;
	private boolean inTransition_ = false;
	private IActionLookup actionLookup_;
	private static Logger logger_ = Logger.getLogger(StateMachine.class);
	
	public static final String STATE_LIST = "states";
	public static final String INITIAL_STATE = "initial-state";
/**
 * StateMachine constructor comment.
 */
public StateMachine() {
	super();
	states_ = new Hashtable();
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public void addState(butterfly.statemachine.interfaces.IState state) {
	states_.put(state.getName(),state);	
}
/**
 * configure method comment.
 */
public void configure(Configuration conf) throws ConfigurationException {
		if(configuration_ == null){
			configuration_ = conf;
			return;
		}
		Configuration statelist = conf.getChild(STATE_LIST);
		String initial = statelist.getAttribute(INITIAL_STATE);
		logger_.debug("InitialState:"+initial);
		Configuration[] states = statelist.getChildren();

		for(int i = 0; i < states.length; i++){
			State state = new State();
			state.setActionLookup(actionLookup_);
			state.configure(states[i]);		
			state.requestActions();
			addState(state);
		}
		setCurrentState(getState(initial));
		
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public butterfly.statemachine.interfaces.IState getCurrentState() {
	return currentState_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public butterfly.statemachine.interfaces.IState getState(String name) {
	return (IState)states_.get(name);
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:23:12 AM)
 * @param event butterfly.statemachine.interfaces.IStateEvent
 */
public synchronized void handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	if(!inTransition_){
		inTransition_ = true;
	logger_.debug("StateEvent received with id:"+event.getID());
	String nextstate = currentState_.handleEvent(event);
	logger_.debug("Next state will be "+nextstate);
	setCurrentState(getState(nextstate));
	logger_.debug("next state entered");
		inTransition_ = false;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public void removeState(butterfly.statemachine.interfaces.IState state) {
	states_.remove(state.getName());	
}
/**
 * Insert the method's description here.
 * Creation date: (9/17/2002 9:31:14 AM)
 */
public void requestActions() {
	try{
		configure(configuration_);
	}catch(Exception e){
		logger_.debug("unable to configure statemachine",e);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/17/2002 9:31:14 AM)
 * @param lookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(IActionLookup lookup) {
	actionLookup_ = lookup;

	
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public void setCurrentState(butterfly.statemachine.interfaces.IState state) {
	currentState_ = state;
	if(state != null){
		currentState_.stateEntered();
	}
	//logger_.debug("Current state set to:"+state.getName());
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 11:14:37 AM)
 * @return butterfly.statemachine.IState
 */
public void setInitialState(butterfly.statemachine.interfaces.IState state) {
	initialState_ = state;
	if(currentState_ == null){
		currentState_ = state;
	}	
}
}
