/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview;

import java.util.Hashtable;


import javax.swing.JFrame;
import javax.swing.KeyStroke;

import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.statemachine.interfaces.IStateMachine;
import butterfly.xmlview.gui.SplashScreen;
import butterfly.xmlview.gui.interfaces.IButterflyDesktop;
/**
 * Insert the type's description here.
 * Creation date: (9/14/2002 11:47:46 AM)
 * @author: 
 */
public class ButterflyApplication
	implements
		IActionLookup,
		IComponent,
		IComponentLookup,
		org.apache.avalon.framework.component.Composable,
		org.apache.avalon.framework.configuration.Configurable {
	private static ButterflyApplication app_;
	private static Logger logger_ =
		Logger.getLogger(ButterflyApplication.class);
	public static final String BUTTERFLY_KEY_BINDINGS = "butterfly-keybindings";
	public static final String BUTTERFLY_COMPONENTS = "butterfly-components";
	public static final String BUTTERFLY_ACTIONS = "butterfly-actions";
	public static final String COMPONENT_NAME = "name";
	public static final String COMPONENT_ROLE = "role";
	public static final String KEY_CODE_ATTRIBUTE = "keychar";
	public static final String MODIFIERS_ATTRIBUTE = "modifiers";
	public static final String KEY_ACTION_ATTRIBUTE = "action-role";
	
	public static final String APPLICATION_ARGUMENTS="app-arguments";
	//public static final String BUTTERFLY_GUI = "butterfly-gui";
	

	private ComponentManager componentManager_;
	private Hashtable actions_;
	private Hashtable components_;
	private IStateMachine stateMachine_;
	private Hashtable applicationProperties_ = new Hashtable();
	private Configuration configuration_;
	/**
	 * ButterflyApplication constructor comment.
	 */
	public ButterflyApplication() {
		super();
		app_ = this;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:27:51 PM)
	 * @param comp butterfly.components.interfaces.IComponent
	 */
	public void addAction(IButterflyAction action, String role) {
		//action.
		//action.setActionLookup(this);
		actions_.put(role, action);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:27:51 PM)
	 * @param comp butterfly.components.interfaces.IComponent
	 */
	public void addComponent(IComponent component, String role) {
		//if(component instanceof IButterflyAction){
		//addAction((IButterflyAction)component,role);
		//return;
		//}
		logger_.debug(
			"Registering Key:" + role + " with Component:" + component);
		components_.put(role, component);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/17/2002 6:49:31 PM)
	 * @param conf org.apache.avalon.framework.configuration.Configuration[]
	 */
	public void buildActions(Configuration conf) {
		if (conf != null) {
			Configuration[] comps = null;
			try {
				comps = conf.getChildren();
			} catch (Exception e) {
				logger_.warn("Error getting component list.", e);
			}
			if (comps != null) {
				String role = null;
				for (int i = 0; i < comps.length; i++) {
					try {
						role = comps[i].getAttribute(COMPONENT_ROLE);
						String name = comps[i].getAttribute(COMPONENT_NAME);

						IButterflyAction action =
							(IButterflyAction) componentManager_.lookup(role);
						setComponentLookupFor(action);
						addAction(action, name);
						addAction(action, role);
					} catch (Exception e) {
						logger_.warn("invalid action-role:"+role);
						logger_.warn(
							"Could not load action into application.",
							e);
					}
				}
			}
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/17/2002 6:49:31 PM)
	 * @param conf org.apache.avalon.framework.configuration.Configuration[]
	 */
	public void buildComponents(Configuration conf) {
		if (conf != null) {
			Configuration[] comps = null;
			try {
				comps = conf.getChildren();
			} catch (Exception e) {
				logger_.warn("Error getting component list.", e);
			}
			if (comps != null) {
				for (int i = 0; i < comps.length; i++) {
					try {
						String role = comps[i].getAttribute(COMPONENT_ROLE);
						String name = comps[i].getAttribute(COMPONENT_NAME);

						IComponent comp =
							(IComponent) componentManager_.lookup(role);
						if (comp instanceof IStateEventSource) {
							((IStateEventSource) comp).addStateEventListener(
								stateMachine_);
						}
						if (comp instanceof JFrame) {
							((JFrame) comp).setExtendedState(
								JFrame.MAXIMIZED_BOTH);
							//setSize(((JFrame)comp).getMaximumSize());
						}
						setComponentLookupFor(comp);
						addComponent(comp, name);
						addComponent(comp, role);
						logger_.debug(
							"Registered component for role:"
								+ role
								+ " in the application.");
					} catch (Exception e) {
						logger_.warn(
							"Could not load component into application.",
							e);
					}
				}
			}
			setComponentLookupFor((IComponent) stateMachine_);
		}
	}
	/**
	 * compose method comment.
	 */
	public void compose(ComponentManager arg1) throws ComponentException {
		componentManager_ = arg1;
		try {
			stateMachine_ =
				(IStateMachine) componentManager_.lookup(IStateMachine.ROLE);
		} catch (Exception e) {
			logger_.warn("Unable to initialize StateMachine");
		}
	}
	/**
	 * configure method comment.
	 */
	public void configure(Configuration arg1) throws ConfigurationException {
		configuration_=arg1;
	}
	public void init(){
		Configuration arg1=configuration_;
		actions_ = new Hashtable(31);
		components_ = new Hashtable(31);
		SplashScreen.progress("Building Actions...");
		buildActions(arg1.getChild(BUTTERFLY_ACTIONS));
		SplashScreen.progress("Building Components...");
		buildComponents(arg1.getChild(BUTTERFLY_COMPONENTS));
		buildKeyBindings(arg1.getChild(BUTTERFLY_KEY_BINDINGS));
		//Enumeration keys = components_.keys();
		//while(keys.hasMoreElements()){
		//IComponent comp = (IComponent)components_.get(keys.nextElement());
		//setComponentLookupFor(comp);
		//}
		//keys = actions_.keys();
		//while(keys.hasMoreElements()){
		//IComponent comp = (IComponent)actions_.get(keys.nextElement());
		//setComponentLookupFor(comp);
		//}
		if (getInstance() == null) {
			app_ = this;
		}
		SplashScreen.progress("Initalizing Parsing Core...");
		stateMachine_.handleEvent(
			new butterfly.statemachine.ApplicationInitializedStateEvent(this));
		SplashScreen.progress("Lift off...");
	}

	private void buildKeyBindings(Configuration kbindings) {
		Configuration[] bindings = kbindings.getChildren();
		IButterflyDesktop desktop = (IButterflyDesktop)getComponent(IButterflyDesktop.ROLE);
		String key = null;
		String mods = null;
		String action = null;
		for (int i = 0; i < bindings.length; i++) {
			try {
			key = bindings[i].getAttribute(KEY_CODE_ATTRIBUTE);
			mods = bindings[i].getAttribute(MODIFIERS_ATTRIBUTE, "none");
			action = bindings[i].getAttribute(KEY_ACTION_ATTRIBUTE);

			
				IButterflyAction todo = getAction(action);
				int modcode = Integer.parseInt(mods);
				char ccode = key.charAt(0);
				KeyStroke keystroke = KeyStroke.getKeyStroke(new Character(ccode),modcode);
				desktop.bindKeystroke(keystroke,todo);
			} catch (Exception e) {
				logger_.debug(
					"Unable to bind key:"
						+ key
						+ " modifiers:"
						+ mods
						+ " to the action:"
						+ action);
				e.printStackTrace();
			}
		}
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:49:16 AM)
	 * @return butterfly.xmlview.ButterflyApplication
	 */
	private Object create(String role) throws Exception {

		return componentManager_.lookup(role);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:47:46 AM)
	 * @return butterfly.actions.interfaces.IButterflyAction
	 * @param role java.lang.String
	 */
	public butterfly.actions.interfaces.IButterflyAction getAction(
		String role) {
		return (IButterflyAction) actions_.get(role);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:47:46 AM)
	 * @return java.awt.Component
	 * @param name java.lang.String
	 */
	public IComponent getComponent(String role) {
		IComponent comp = (IComponent) components_.get(role);
		if (comp == null) {
			logger_.debug("Could not find component for role:" + role);
		}
		return comp;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:49:16 AM)
	 * @return butterfly.xmlview.ButterflyApplication
	 */
	public static ButterflyApplication getInstance() {

		return app_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/14/2002 11:49:16 AM)
	 * @return butterfly.xmlview.ButterflyApplication
	 */
	public static Object lookup(String role) throws Exception {

		return app_.create(role);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/16/2002 4:06:37 PM)
	 * @param comp butterfly.components.interfaces.IComponent
	 */
	private void setComponentLookupFor(IComponent comp) {
		if (comp instanceof IActionRequester) {
			((IActionRequester) comp).setActionLookup(this);
			((IActionRequester) comp).requestActions();
		}
		if (comp instanceof IComponentRequester) {
			((IComponentRequester) comp).setComponentLookup(this);
			((IComponentRequester) comp).requestComponents();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/6/2002 10:11:08 AM)
	 * @param obj java.lang.Object
	 */
	public static void setLookups(Object obj) {
		if (obj instanceof IActionRequester) {
			((IActionRequester) obj).setActionLookup(app_);
		}
		if (obj instanceof IComponentRequester) {
			((IComponentRequester) obj).setComponentLookup(app_);
		}
	}
	
	
	/**
	 * @return Returns the applicationProperties_.
	 */
	public Hashtable getApplicationProperties() {
		return applicationProperties_;
	}

	public void setApplicationProperty(String prop, Object val){
		applicationProperties_.put(prop,val);
	}
	public Object getApplicationProperty(String prop){
		return applicationProperties_.get(prop);
	}

}
