/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview;

import java.util.Enumeration;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.xmlview.model.AbstractDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/8/2002 2:01:50 PM)
 * @author: 
 */
public class ButterflyProject extends AbstractDocument implements IProject,Configurable{

class RootFolder extends ProjectFolder{
	
	
	/**
	 * Constructor for RootFolder.
	 * @param parent
	 * @param name
	 */
	public RootFolder(IProjectFolder parent, String name) {
		super(parent, name);
	}
	
	public void setName(String name){
		//super.setName(name);
		if(!getProjectName().equals(name)){
			setProjectName(name);	
		}
	}
	
	public String getName(){
		return getProjectName();	
	}

public String toXml() {
	StringBuffer buffer = new StringBuffer("");
	
	IProjectFolder[] folders = listFolders();
	for(int i = 0; i < folders.length; i++){
		buffer.append(folders[i].toXml());
		buffer.append("\n");
	}
	IProjectFile[] files = listFiles();
	for(int i = 0; i < files.length; i++){
		buffer.append(files[i].toXml());
		buffer.append("\n");
	}
	
	return buffer.toString();
}	
}
	
	public static final String PROJECT_NAME_KEY = "project-name";
	public static final String PROJECT_TAG = "butterfly-project";
	public static final String PROJECT_HOME_ATTRIBUTE = "project-home";
	public static final String PROJECT_NAME_ATTRIBUTE = "project-name";
	public static final String PROJECT_PROPERTY_TAG = "project-property";
	public static final String PROJECT_PROPERTY_KEY_ATTRIBUTE = "key";
	public static final String PROJECT_PROPERTY_VALUE_ATTRIBUTE = "value";
	public static final String PROJECT_PROPERTIES_TAG = "project-properties";
	public static final String PROJECT_FOLDERS_TAG = "project-folders";
	public static final String BUTTERFLY_PROJECT_CONTENT_TYPE = "text/butterfly-project";
	private IProjectFolder rootFolder_;

	private static final String startProjectTag_ = "<"+PROJECT_TAG;
	private static final String endProjectTag_ = "</"+PROJECT_TAG+">";

	private static Logger logger_ = Logger.getLogger(ButterflyProject.class);
	
	
/**
 * ButterflyProject constructor comment.
 */
public ButterflyProject(String name) {
	super(PROJECT_XML_TYPE);
	setProperty(PROJECT_NAME_KEY,name);
	rootFolder_= new RootFolder(null,"/");
	rootFolder_.setProject(this);
}
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 4:12:23 PM)
 * @param path java.lang.String
 * @param name java.lang.String
 */
public void addFile(String vpath, IProjectFile file) throws Exception{
	IProjectFolder folder = rootFolder_.getFolder(vpath);
	
	if(folder != null){
		folder.addFile(file);
	}
	else{
		throw new Exception("Invalid path");
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 11:16:15 AM)
 * @param conf org.apache.avalon.framework.configuration.Configuration
 */
private void addFolder(IProjectFolder parent, Configuration conf) {
   
    String name = null;
    try {
	    logger_.debug("getting the folder name...");
        name = conf.getAttribute(IProjectFolder.PROJECT_FOLDER_NAME_ATTRIBUTE);
        logger_.debug("the folder is:"+name);
		if(rootFolder_ == null){
			name = getName()+name;	
		}
        
        IProjectFolder folder = new ProjectFolder(null, name);
        folder.setProject(this);
 		if (rootFolder_ == null) {
	        logger_.debug("set the root folder to: "+folder.getName());
        	rootFolder_ = folder;
        	
    	}
        
        if(parent != null){
	        logger_.debug("setting the folder's parent to: "+parent.getName());
       		parent.addFolder(folder);
        }
        
       

        
		logger_.debug("getting the sub-folders...");
        Configuration[] subfolders = conf.getChild(IProjectFolder.SUB_FOLDERS_TAG).getChildren();
        Configuration[] files = conf.getChild(IProjectFolder.FILES_TAG).getChildren();

        for (int i = 0; i < subfolders.length; i++) {
            addFolder(folder, subfolders[i]);
        }
        for (int i = 0; i < files.length; i++) {
	        String fname = files[i].getAttribute(IProjectFile.PROJECT_FILE_NAME_ATTRIBUTE);
	        logger_.debug("Adding file: "+fname);
            folder.addFile(
                new ProjectFile(
                    fname));
        }

    } catch (Exception e) {
        logger_.debug("Unable to load project folder named: " + name,e);
    }

}
/**
 * configure method comment.
 */
public void configure(Configuration conf) throws ConfigurationException {
		//rootFolder_ = null;
		
		String name = conf.getAttribute(PROJECT_NAME_ATTRIBUTE);
		Configuration[] props = conf.getChild(PROJECT_PROPERTIES_TAG).getChildren();
		Configuration[] folders = conf.getChild(PROJECT_FOLDERS_TAG).getChildren();

		for(int i = 0; i < props.length; i++){
			String key = props[i].getAttribute(PROJECT_PROPERTY_KEY_ATTRIBUTE);
			String value = props[i].getAttribute(PROJECT_PROPERTY_VALUE_ATTRIBUTE);
			logger_.debug("Setting property key:"+key+" value:"+value);
			setProperty(key,value);
		}
		setProjectName(name);
		for(int i= 0; i< folders.length; i++){
			if(folders[i].getName().equals(IProjectFile.PROJECT_FILE_TAG)){
				 String fname = folders[i].getAttribute(IProjectFile.PROJECT_FILE_NAME_ATTRIBUTE);
	       		 logger_.debug("Adding file: "+fname);
            	 rootFolder_.addFile(
               		 new ProjectFile(
                    fname));
   				 
   			}
   			else{
				addFolder(rootFolder_,folders[i]);
   			}
		}
}
/**
 * configure method comment.
 */
//public void configure(org.apache.avalon.framework.configuration.Configuration arg1) throws org.apache.avalon.framework.configuration.ConfigurationException {}
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 4:08:04 PM)
 * @param path java.lang.String
 * @param name java.lang.String
 */
public void createFolder(String path, String name) throws Exception{
	rootFolder_.addFolder(path, new ProjectFolder(null,name));	
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 11:04:59 AM)
 * @return java.lang.String
 */
public String getProjectName() {
	return getProperty(PROJECT_NAME_KEY);
}

public void setProjectName(String name) {
	setProperty(PROJECT_NAME_KEY,name);
	if(rootFolder_ != null){
		((ProjectFolder)rootFolder_).setName(name);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/2002 9:21:47 AM)
 * @return butterfly.xmlview.model.interfaces.INode
 */
public butterfly.xmlview.model.interfaces.INode getRoot() {
	return getRootFolder();
}
public IProjectFolder getRootFolder(){
	return rootFolder_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 4:08:04 PM)
 * @param path java.lang.String
 * @param name java.lang.String
 */
public void removeFile(String path,IProjectFile file) throws Exception{
	IProjectFolder folder = rootFolder_.getFolder(path);
	if(folder != null){
		folder.removeFile(file);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 4:08:04 PM)
 * @param path java.lang.String
 * @param name java.lang.String
 */
public void removeFolder(String path) throws Exception{
	IProjectFolder folder = rootFolder_.getFolder(path);
	if(folder != null){
		if(!folder.equals(rootFolder_)){
			IProjectFolder parent = folder.getParentFolder();
			parent.removeFolder(folder);
			folder.setParentFolder(null);
			folder = null;
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/14/2002 6:00:29 PM)
 * @return java.lang.String
 */
public String toString() {
	return toXml();
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 10:50:29 AM)
 * @return java.lang.String
 */
public String toXml() {
	StringBuffer buffer = new StringBuffer(startProjectTag_);
	buffer.append(" ");
	buffer.append(PROJECT_NAME_ATTRIBUTE);
	buffer.append("=");
	buffer.append("\"");
	buffer.append(getProjectName());
	buffer.append("\"");
	buffer.append(">\n");

	buffer.append("<");
	buffer.append(PROJECT_PROPERTIES_TAG);
	buffer.append(">\n");
	String key = null;
	Enumeration e = getProperties().keys();
	while(e.hasMoreElements()){
		buffer.append("<");
		buffer.append(PROJECT_PROPERTY_TAG);
		buffer.append(" ");
		buffer.append(PROJECT_PROPERTY_KEY_ATTRIBUTE);
		buffer.append("=");
		buffer.append("\"");
		key = (String)e.nextElement();
		buffer.append(key);
		buffer.append("\" ");
		buffer.append(PROJECT_PROPERTY_VALUE_ATTRIBUTE);
		buffer.append("=");
		buffer.append("\"");
		buffer.append(getProperty(key));
		buffer.append("\"/>\n");
	}
	buffer.append("</");
	buffer.append(PROJECT_PROPERTIES_TAG);
	buffer.append(">\n");

	
	buffer.append("<");
	buffer.append(PROJECT_FOLDERS_TAG);
	buffer.append(">");
	buffer.append(getRootFolder().toXml());
	buffer.append("\n");
	buffer.append("</");
	buffer.append(PROJECT_FOLDERS_TAG);
	buffer.append(">");

	buffer.append(endProjectTag_);
	return buffer.toString();
}

public String getName(){
	return getProjectName();	
}
}
