/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview;

import butterfly.xmlview.model.Node;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DocumentNode extends Node {
	private IDocument document_;
	
	public DocumentNode(IDocument doc){
		document_ = doc;	
	}
	/**
	 * @see butterfly.xmlview.model.interfaces.INode#addChild(int, INode)
	 */
	public void addChild(int index, INode element) {
		//super.addChild(index, element);
		document_.getRoot().addChild(index,element);
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.INode#childCount()
	 */
	public int childCount() {
		return document_.getRoot().childCount();
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.INode#removeChild(INode)
	 */
	public void removeChild(INode attr) {
		//super.removeChild(attr);
		document_.getRoot().removeChild(attr);
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.INode#childAt(int)
	 */
	public INode childAt(int index) {
		return document_.getRoot().childAt(index);
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.INode#indexOfChild(INode)
	 */
	public int indexOfChild(INode child) {
		return document_.getRoot().indexOfChild(child);
	}
	
	public String toString(){
		return document_.getName();	
	}

	/**
	 * @see butterfly.xmlview.model.Node#createNode()
	 */
	protected INode createNode() {
		return null;
	}

}
