/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview;

/**
 * Insert the type's description here.
 * Creation date: (11/8/2002 6:10:31 PM)
 * @author: 
 */
public interface IProjectFolder extends IProjectElement{
	public static final String PROJECT_FOLDER_TAG = "project-folder";
	public static final String SUB_FOLDERS_TAG = "folders";
	public static final String FILES_TAG ="files";
	
	public static final String PROJECT_FOLDER_NAME_ATTRIBUTE = "name";
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:55:08 PM)
 * @param file butterfly.xmlview.IProjectFile
 */
void addFile(IProjectFile file);
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:56:52 PM)
 * @param f butterfly.xmlview.IProjectFolder
 */
void addFolder(IProjectFolder f);
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 11:22:17 AM)
 * @return butterfly.xmlview.IProjectFolder
 * @param path java.lang.String
 * @exception java.lang.Exception The exception description.
 */
void addFolder(String path,IProjectFolder f) throws java.lang.Exception;
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 11:22:17 AM)
 * @return butterfly.xmlview.IProjectFolder
 * @param path java.lang.String
 * @exception java.lang.Exception The exception description.
 */
IProjectFolder getFolder(String path) throws java.lang.Exception;
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:56:31 PM)
 * @return butterfly.xmlview.IProjectFolder
 */
IProjectFolder getParentFolder();
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:57:21 PM)
 * @return java.lang.String
 */
String getPath();
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:11:52 PM)
 * @return butterfly.xmlview.IProjectFile[]
 */
IProjectFile[] listFiles();
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:11:52 PM)
 * @return butterfly.xmlview.IProjectFile[]
 */
IProjectFolder[] listFolders();
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:55:08 PM)
 * @param file butterfly.xmlview.IProjectFile
 */
void removeFile(IProjectFile file);
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:56:52 PM)
 * @param f butterfly.xmlview.IProjectFolder
 */
void removeFolder(IProjectFolder f);
/**
 * Insert the method's description here.
 * Creation date: (11/8/2002 6:57:42 PM)
 * @param f butterfly.xmlview.IProjectFolder
 */
void setParentFolder(IProjectFolder f);
}
